/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.wildfly.clustering.server.singleton;

import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.Messages;

/**
 * SingletonMessages
 *
 * logging id ranges: 10350 - 10359
 *
 * @author <a href="mailto:pferraro@redhat.com">Paul Ferraro</a>
 */
@MessageBundle(projectCode = "JBAS")
public interface SingletonMessages {

    SingletonMessages MESSAGES = Messages.getBundle(SingletonMessages.class);

    @Message(id = 10350, value = "Expected service %s value from singleton master only, but instead received %d results.")
    IllegalStateException unexpectedResponseCount(String serviceName, int results);

    @Message(id = 10351, value = "Singleton service %s is not started.")
    IllegalStateException notStarted(String serviceName);
}
