/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Map.class.isAssignableFrom(type) && !Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type);
        if (value != null) {
            return value;
        }
        try {
            Map<Object, Object> map = this.instantiateMap(configuration, type, loader);
            int i = 0;
            int size = configuration.getChildCount();
            while (i < size) {
                PlexusConfiguration element = configuration.getChild(i);
                map.put(element.getName(), this.fromExpression(element, evaluator));
                ++i;
            }
            return map;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Map<Object, Object> instantiateMap(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            return new TreeMap<Object, Object>();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Map)impl;
    }
}

