/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Locale;
import org.wildfly.security.manager.WildFlySecurityManager;

public class NetworkUtils {
    private static final int IPV6_LEN = 8;
    private static final boolean can_bind_to_mcast_addr = NetworkUtils.checkForLinux() || NetworkUtils.checkForSolaris() || NetworkUtils.checkForHp();

    public static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    public static String formatAddress(InetAddress inet) {
        if (inet == null) {
            throw new NullPointerException();
        }
        if (inet instanceof Inet4Address) {
            return inet.getHostAddress();
        }
        if (inet instanceof Inet6Address) {
            byte[] byteRepresentation = inet.getAddress();
            int[] hexRepresentation = new int[8];
            for (int i = 0; i < hexRepresentation.length; ++i) {
                hexRepresentation[i] = (byteRepresentation[2 * i] & 0xFF) << 8 | byteRepresentation[2 * i + 1] & 0xFF;
            }
            NetworkUtils.compactLongestZeroSequence(hexRepresentation);
            return NetworkUtils.formatAddress6(hexRepresentation);
        }
        return inet.getHostAddress();
    }

    public static String formatAddress(InetSocketAddress inet) {
        if (inet == null) {
            throw new NullPointerException();
        }
        StringBuilder result = new StringBuilder();
        if (inet.isUnresolved()) {
            result.append(inet.getHostName());
        } else {
            result.append(NetworkUtils.formatPossibleIpv6Address(NetworkUtils.formatAddress(inet.getAddress())));
        }
        result.append(":").append(inet.getPort());
        return result.toString();
    }

    private static String formatAddress6(int[] hexRepresentation) {
        if (hexRepresentation == null) {
            throw new NullPointerException();
        }
        if (hexRepresentation.length != 8) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean inCompressedSection = false;
        for (int i = 0; i < hexRepresentation.length; ++i) {
            if (hexRepresentation[i] == -1) {
                if (inCompressedSection) continue;
                inCompressedSection = true;
                if (i == 0) {
                    stringBuilder.append("::");
                    continue;
                }
                stringBuilder.append(":");
                continue;
            }
            inCompressedSection = false;
            stringBuilder.append(Integer.toHexString(hexRepresentation[i]));
            if (i + 1 >= hexRepresentation.length) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    public static boolean isBindingToMulticastDressSupported() {
        return can_bind_to_mcast_addr;
    }

    private static void compactLongestZeroSequence(int[] hexRepresentatoin) {
        int bestRunStart = -1;
        int bestRunLen = -1;
        boolean inRun = false;
        int runStart = -1;
        for (int i = 0; i < hexRepresentatoin.length; ++i) {
            if (hexRepresentatoin[i] == 0) {
                if (inRun) continue;
                runStart = i;
                inRun = true;
                continue;
            }
            if (!inRun) continue;
            inRun = false;
            int runLen = i - runStart;
            if (bestRunLen < 0) {
                bestRunStart = runStart;
                bestRunLen = runLen;
                continue;
            }
            if (runLen <= bestRunLen) continue;
            bestRunStart = runStart;
            bestRunLen = runLen;
        }
        if (bestRunStart >= 0) {
            Arrays.fill(hexRepresentatoin, bestRunStart, bestRunStart + bestRunLen, -1);
        }
    }

    private static boolean checkForLinux() {
        return NetworkUtils.checkForPresence("os.name", "linux");
    }

    private static boolean checkForHp() {
        return NetworkUtils.checkForPresence("os.name", "hp");
    }

    private static boolean checkForSolaris() {
        return NetworkUtils.checkForPresence("os.name", "sun");
    }

    private static boolean checkForWindows() {
        return NetworkUtils.checkForPresence("os.name", "win");
    }

    public static boolean checkForMac() {
        return NetworkUtils.checkForPresence("os.name", "mac");
    }

    private static boolean checkForPresence(String key, String value) {
        String tmp = WildFlySecurityManager.getPropertyPrivileged((String)key, (String)value);
        try {
            return tmp != null && tmp.trim().toLowerCase(Locale.ENGLISH).startsWith(value);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private NetworkUtils() {
    }
}

