/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public final class BlockingHandler
implements HttpHandler {
    private volatile HttpHandler handler;

    public BlockingHandler(HttpHandler handler) {
        this.handler = handler;
    }

    public BlockingHandler() {
        this(null);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.startBlocking();
        if (exchange.isInIoThread()) {
            exchange.dispatch(this.handler);
        } else {
            this.handler.handleRequest(exchange);
        }
    }

    public HttpHandler getHandler() {
        return this.handler;
    }

    public BlockingHandler setRootHandler(HttpHandler rootHandler) {
        this.handler = rootHandler;
        return this;
    }
}

