/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.protocol.http.HttpTransferEncoding;
import io.undertow.server.protocol.http.ParseState;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSourceConduit;

final class HttpReadListener
implements ChannelListener<ConduitStreamSourceChannel>,
Runnable {
    private static final String BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nContent-Length: 0\r\nConnection: close\r\n\r\n";
    private final HttpServerConnection connection;
    private final ParseState state = new ParseState();
    private final HttpRequestParser parser;
    private HttpServerExchange httpServerExchange;
    private int read = 0;
    private final int maxRequestSize;
    private final long maxEntitySize;
    private final boolean recordRequestStartTime;
    private volatile int requestState;
    private static final AtomicIntegerFieldUpdater<HttpReadListener> requestStateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpReadListener.class, "requestState");

    HttpReadListener(HttpServerConnection connection, HttpRequestParser parser) {
        this.connection = connection;
        this.parser = parser;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 51200);
        this.maxEntitySize = connection.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, 0L);
        this.recordRequestStartTime = connection.getUndertowOptions().get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
    }

    public void newRequest() {
        this.state.reset();
        this.read = 0;
        this.httpServerExchange = new HttpServerExchange(this.connection, this.maxEntitySize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ConduitStreamSourceChannel channel) {
        Pooled existing = this.connection.getExtraBytes();
        if (existing == null && (this.connection.getOriginalSinkConduit().isWriteShutdown() || this.connection.getOriginalSourceConduit().isReadShutdown())) {
            IoUtils.safeClose((Closeable)((Object)this.connection));
            channel.suspendReads();
            return;
        }
        while (requestStateUpdater.get(this) != 0) {
            if (!requestStateUpdater.compareAndSet(this, 1, 2)) continue;
            channel.suspendReads();
            requestStateUpdater.set(this, 1);
            return;
        }
        Pooled pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        boolean free = true;
        try {
            do {
                int total;
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.debug("Error reading request", e);
                        IoUtils.safeClose((Closeable)((Object)this.connection));
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res <= 0) {
                    this.handleFailedRead(channel, res);
                    return;
                }
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                this.parser.handle(buffer, this.state, this.httpServerExchange);
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes((Pooled<ByteBuffer>)pooled);
                }
                this.read = total = this.read + res;
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)((Object)this.connection));
                return;
            } while (!this.state.isComplete());
            HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.setRequestScheme(this.connection.getSslSession() != null ? "https" : "http");
            this.httpServerExchange = null;
            requestStateUpdater.set(this, 1);
            HttpTransferEncoding.setupRequest(httpServerExchange);
            if (this.recordRequestStartTime) {
                Connectors.setRequestStartTime(httpServerExchange);
            }
            Connectors.executeRootHandler(this.connection.getRootHandler(), httpServerExchange);
        }
        catch (Exception e) {
            this.sendBadRequestAndClose(this.connection.getChannel(), e);
            return;
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private void handleFailedRead(ConduitStreamSourceChannel channel, int res) {
        if (res == 0) {
            channel.setReadListener((ChannelListener)this);
            channel.resumeReads();
        } else if (res == -1) {
            this.handleConnectionClose((StreamSourceChannel)channel);
        }
    }

    private void handleConnectionClose(StreamSourceChannel channel) {
        try {
            channel.suspendReads();
            channel.shutdownReads();
            ConduitStreamSinkChannel responseChannel = this.connection.getChannel().getSinkChannel();
            responseChannel.shutdownWrites();
            if (!responseChannel.flush()) {
                responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                responseChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.debug("Error reading request", e);
            IoUtils.safeClose((Closeable)((Object)this.connection));
        }
    }

    private void sendBadRequestAndClose(final StreamConnection connection, Exception exception) {
        UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(exception);
        connection.getSourceChannel().suspendReads();
        new StringWriteChannelListener(BAD_REQUEST){

            @Override
            protected void writeDone(StreamSinkChannel c) {
                super.writeDone(c);
                c.suspendWrites();
                IoUtils.safeClose((Closeable)connection);
            }

            @Override
            protected void handleError(StreamSinkChannel channel, IOException e) {
                IoUtils.safeClose((Closeable)connection);
            }
        }.setup((StreamSinkChannel)connection.getSinkChannel());
    }

    public void exchangeComplete(HttpServerExchange exchange) {
        this.connection.clearChannel();
        HttpServerConnection connection = this.connection;
        if (exchange.isPersistent() && !exchange.isUpgrade()) {
            StreamConnection channel = connection.getChannel();
            if (connection.getExtraBytes() == null) {
                while (requestStateUpdater.get(this) != 0) {
                    if (!requestStateUpdater.compareAndSet(this, 1, 2)) continue;
                    this.newRequest();
                    channel.getSourceChannel().setReadListener((ChannelListener)this);
                    channel.getSourceChannel().resumeReads();
                    requestStateUpdater.set(this, 0);
                }
            } else {
                requestStateUpdater.set(this, 0);
                this.newRequest();
                if (exchange.isInIoThread()) {
                    channel.getIoThread().execute((Runnable)this);
                } else {
                    channel.getSourceChannel().suspendReads();
                    Executor executor = exchange.getDispatchExecutor();
                    if (executor == null) {
                        executor = exchange.getConnection().getWorker();
                    }
                    executor.execute(this);
                }
            }
        } else if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)((Object)connection));
        } else if (exchange.isUpgrade()) {
            if (connection.getExtraBytes() != null) {
                connection.getChannel().getSourceChannel().setConduit((StreamSourceConduit)new ReadDataStreamSourceConduit(connection.getChannel().getSourceChannel().getConduit(), connection));
            }
            connection.getUpgradeListener().handleUpgrade(connection.getChannel(), exchange);
        }
    }

    @Override
    public void run() {
        this.handleEvent(this.connection.getChannel().getSourceChannel());
    }
}

