/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.util.List;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.validation.Artifact;
import org.jboss.as.patching.validation.ArtifactCollectionState;
import org.jboss.as.patching.validation.ArtifactWithCollectionState;
import org.jboss.as.patching.validation.Context;
import org.jboss.as.patching.validation.PatchElementProviderArtifact;
import org.jboss.as.patching.validation.PatchXmlArtifact;

public class PatchElementArtifact
extends ArtifactWithCollectionState<PatchXmlArtifact.State, ElementState, State> {
    private static final PatchElementArtifact INSTANCE = new PatchElementArtifact();

    public static PatchElementArtifact getInstance() {
        return INSTANCE;
    }

    private PatchElementArtifact() {
        this.addArtifact(PatchElementProviderArtifact.getInstance());
    }

    @Override
    protected State getInitialState(PatchXmlArtifact.State parent, Context ctx) {
        State elements = parent.getPatchElements();
        if (elements != null) {
            return elements;
        }
        elements = new State(parent.getPatch().getElements());
        parent.setPatchElements(elements);
        return elements;
    }

    public class State
    extends ArtifactCollectionState<ElementState> {
        State() {
        }

        State(List<PatchElement> elements) {
            for (PatchElement e : elements) {
                ElementState s = (ElementState)this.newItem();
                s.init(e);
            }
        }

        @Override
        protected ElementState createItem() {
            return new ElementState();
        }

        public PatchElementProviderArtifact.State getLayer() {
            ElementState state = (ElementState)this.getState();
            if (state == null) {
                return null;
            }
            return state.getLayer();
        }

        void setLayer(PatchElementProviderArtifact.State layer) {
            ElementState state = (ElementState)this.getState();
            if (state == null) {
                throw new IllegalStateException("patch element doesn't exist");
            }
            state.setLayer(layer);
        }

        public PatchElement getMetadata() {
            ElementState state = (ElementState)this.getState();
            if (state == null) {
                return null;
            }
            return state.getMetadata();
        }
    }

    public class ElementState
    implements Artifact.State {
        private PatchElement metadata;
        private PatchElementProviderArtifact.State layer;

        void init(PatchElement metadata) {
            this.metadata = metadata;
        }

        PatchElement getMetadata() {
            return this.metadata;
        }

        public PatchElementProviderArtifact.State getLayer() {
            return this.layer;
        }

        void setLayer(PatchElementProviderArtifact.State layer) {
            this.layer = layer;
        }

        @Override
        public void validate(Context ctx) {
        }
    }
}

