/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11;

import java.util.Map;
import java.util.TreeMap;

public class ServiceRegistry {
    private static final ServiceRegistry REGISTRY = new ServiceRegistry();
    private final Map<String, String> serviceProviderRegistry = new TreeMap<String, String>();
    private final Map<String, String> secureServiceProviderRegistry = new TreeMap<String, String>();

    public static ServiceRegistry getRegistry() {
        return REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServiceProvider(String serviceName, String url) {
        Map<String, String> map = this.serviceProviderRegistry;
        synchronized (map) {
            this.serviceProviderRegistry.put(serviceName, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSecureServiceProvider(String serviceName, String url) {
        Map<String, String> map = this.secureServiceProviderRegistry;
        synchronized (map) {
            this.secureServiceProviderRegistry.put(serviceName, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceProvider(String serviceName) {
        Map<String, String> map = this.serviceProviderRegistry;
        synchronized (map) {
            this.serviceProviderRegistry.remove(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecureServiceProvider(String serviceName) {
        Map<String, String> map = this.secureServiceProviderRegistry;
        synchronized (map) {
            this.secureServiceProviderRegistry.remove(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceURI(String serviceName) {
        String uri;
        Map<String, String> map = this.serviceProviderRegistry;
        synchronized (map) {
            uri = this.serviceProviderRegistry.get(serviceName);
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecureServiceURI(String serviceName) {
        String uri;
        Map<String, String> map = this.secureServiceProviderRegistry;
        synchronized (map) {
            uri = this.secureServiceProviderRegistry.get(serviceName);
        }
        return uri;
    }

    public String getServiceURI(String serviceName, boolean isSecure) {
        if (isSecure) {
            return this.getSecureServiceURI(serviceName);
        }
        return this.getServiceURI(serviceName);
    }
}

