/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    protected final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;

    protected DeploymentAddHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.vaultReader = vaultReader;
    }

    public static DeploymentAddHandler create(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new DeploymentAddHandler(contentRepository, vaultReader);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DeploymentHandlerUtil.ContentItem contentItem;
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode newModel = resource.getModel();
        if (!operation.hasDefined(DeploymentAttributes.PERSISTENT.getName())) {
            operation.get(DeploymentAttributes.PERSISTENT.getName()).set(true);
        }
        DeploymentAttributes.PERSISTENT.validateAndSet(operation, newModel);
        for (AttributeDefinition def : DeploymentAttributes.SERVER_ADD_ATTRIBUTES) {
            if (!def.getName().equals(DeploymentAttributes.CONTENT_ALL.getName())) {
                def.validateAndSet(operation, newModel);
                continue;
            }
            def.validateOperation(operation);
        }
        ModelNode content = operation.require(DeploymentAttributes.CONTENT_ALL.getName());
        ModelNode contentItemNode = content.require(0);
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        String runtimeName = operation.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) ? operation.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString() : name;
        newModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).set(runtimeName);
        if (contentItemNode.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            byte[] hash = contentItemNode.require(DeploymentAttributes.CONTENT_HASH.getName()).asBytes();
            contentItem = this.addFromHash(hash, name, context);
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined(contentItemNode)) {
            contentItem = this.addFromContentAdditionParameter(context, name, contentItemNode);
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(contentItem.getHash());
            content = new ModelNode();
            content.add(contentItemNode);
        } else {
            contentItem = this.addUnmanaged(contentItemNode);
        }
        newModel.get(DeploymentAttributes.CONTENT_ALL.getName()).set(content);
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    DeploymentAddHandler.this.validateRuntimeNames(name, context);
                }
            }, OperationContext.Stage.MODEL);
        }
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, newModel).asBoolean() && context.isNormalServer()) {
            DeploymentHandlerUtil.deploy(context, runtimeName, name, this.vaultReader, contentItem);
        }
        if (this.contentRepository != null && contentItem.getHash() != null) {
            final byte[] contentHash = contentItem.getHash();
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        DeploymentAddHandler.this.contentRepository.addContentReference(contentHash, (Object)name);
                    }
                }
            });
        } else {
            context.stepCompleted();
        }
    }

    private void validateRuntimeNames(String deploymentName, OperationContext context) throws OperationFailedException {
        ModelNode deployment = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deployment).asBoolean()) {
            String runtimeName = DeploymentAddHandler.getRuntimeName(deploymentName, deployment);
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            for (Resource.ResourceEntry re : root.getChildren("deployment")) {
                String otherRuntimeName;
                ModelNode otherDepl;
                String reName = re.getName();
                if (deploymentName.equals(reName) || !DeploymentAttributes.ENABLED.resolveModelAttribute(context, otherDepl = re.getModel()).asBoolean() || !runtimeName.equals(otherRuntimeName = DeploymentAddHandler.getRuntimeName(reName, otherDepl))) continue;
                throw ServerMessages.MESSAGES.runtimeNameMustBeUnique(reName, runtimeName);
            }
        }
        context.stepCompleted();
    }

    private static String getRuntimeName(String name, ModelNode deployment) {
        return deployment.hasDefined("runtime-name") ? deployment.get("runtime-name").asString() : name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash, String deploymentName, OperationContext context) throws OperationFailedException {
        if (this.contentRepository.syncContent(hash)) return new DeploymentHandlerUtil.ContentItem(hash);
        if (!context.isBooting()) throw ServerMessages.MESSAGES.noSuchDeploymentContent(HashUtil.bytesToHexString((byte[])hash));
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw ServerMessages.MESSAGES.noSuchDeploymentContentAtBoot(HashUtil.bytesToHexString((byte[])hash), deploymentName);
        ServerLogger.DEPLOYMENT_LOGGER.reportAdminOnlyMissingDeploymentContent(HashUtil.bytesToHexString((byte[])hash), deploymentName);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, String name, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentHandlerUtils.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw DeploymentHandlerUtils.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(ModelNode contentItemNode) throws OperationFailedException {
        String path = contentItemNode.require(DeploymentAttributes.CONTENT_PATH.getName()).asString();
        String relativeTo = DeploymentHandlerUtils.asString(contentItemNode, DeploymentAttributes.CONTENT_RELATIVE_TO.getName());
        boolean archive = contentItemNode.require(DeploymentAttributes.CONTENT_ARCHIVE.getName()).asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }
}

