/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayLinkService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DeploymentOverlayIndexService
implements Service<DeploymentOverlayIndexService> {
    private final List<DeploymentOverlayLinkService> services = new ArrayList<DeploymentOverlayLinkService>();
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"deploymentOverlayIndexService"});

    public synchronized void start(StartContext context) throws StartException {
    }

    public synchronized void stop(StopContext context) {
        this.services.clear();
    }

    public synchronized void addService(DeploymentOverlayLinkService service) {
        this.services.add(service);
    }

    public synchronized void removeService(DeploymentOverlayLinkService service) {
        this.services.remove(service);
    }

    public synchronized List<DeploymentOverlayService> getOverrides(String deploymentName) {
        ArrayList<DeploymentOverlayLinkService> matched = new ArrayList<DeploymentOverlayLinkService>();
        for (DeploymentOverlayLinkService service : this.services) {
            if (service.isWildcard()) {
                if (!service.getPattern().matcher(deploymentName).matches()) continue;
                matched.add(service);
                continue;
            }
            if (!service.getDeployment().equals(deploymentName)) continue;
            matched.add(service);
        }
        Collections.sort(matched, new Comparator<DeploymentOverlayLinkService>(){

            @Override
            public int compare(DeploymentOverlayLinkService o1, DeploymentOverlayLinkService o2) {
                int res = o1.getPriority().ordinal() - o2.getPriority().ordinal();
                if (res != 0) {
                    return res;
                }
                if (o2.isWildcard() && !o1.isWildcard()) {
                    return -1;
                }
                if (o1.isWildcard() && !o2.isWildcard()) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<DeploymentOverlayService> ret = new ArrayList<DeploymentOverlayService>();
        for (DeploymentOverlayLinkService i : matched) {
            ret.add((DeploymentOverlayService)i.getDeploymentOverlayServiceInjectedValue().getValue());
        }
        return ret;
    }

    private boolean wildcardMatch(String wildcard, String deploymentName) {
        if (wildcard.startsWith("*")) {
            return deploymentName.endsWith(wildcard.substring(1));
        }
        if (wildcard.endsWith("*")) {
            return deploymentName.startsWith(wildcard.substring(0, wildcard.length() - 1));
        }
        return false;
    }

    public DeploymentOverlayIndexService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

