/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.internal;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.permission.PermissionResolver;

public class PermissionMapper {
    private List<PermissionResolver> resolvers;

    public boolean resolvePermission(Object resource, String operation) {
        boolean permit = false;
        for (PermissionResolver resolver : this.resolvers) {
            PermissionResolver.PermissionStatus status = resolver.hasPermission(resource, operation);
            if (PermissionResolver.PermissionStatus.ALLOW.equals((Object)status)) {
                permit = true;
                continue;
            }
            if (!PermissionResolver.PermissionStatus.DENY.equals((Object)status)) continue;
            return false;
        }
        return permit;
    }

    public boolean resolvePermission(Class<?> resourceClass, Serializable identifier, String operation) {
        boolean permit = false;
        for (PermissionResolver resolver : this.resolvers) {
            PermissionResolver.PermissionStatus status = resolver.hasPermission(resourceClass, identifier, operation);
            if (PermissionResolver.PermissionStatus.ALLOW.equals((Object)status)) {
                permit = true;
                continue;
            }
            if (!PermissionResolver.PermissionStatus.DENY.equals((Object)status)) continue;
            return false;
        }
        return permit;
    }
}

