/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

public class NamePasswordCallbackHandler
implements CallbackHandler {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(NamePasswordCallbackHandler.class);
    private static final Logger LOG = LogUtils.getL7dLogger(NamePasswordCallbackHandler.class);
    private static final String PASSWORD_CALLBACK_NAME = "setObject";
    private static final Class<?>[] PASSWORD_CALLBACK_TYPES = new Class[]{Object.class, char[].class, String.class};
    private String username;
    private String password;
    private String passwordCallbackName;

    public NamePasswordCallbackHandler(String username, String password) {
        this(username, password, null);
    }

    public NamePasswordCallbackHandler(String username, String password, String passwordCallbackName) {
        this.username = username;
        this.password = password;
        this.passwordCallbackName = passwordCallbackName;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (this.handleCallback(callback)) continue;
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pwCallback = (PasswordCallback)callback;
                pwCallback.setPassword(this.password.toCharArray());
                continue;
            }
            if (this.invokePasswordCallback(callback)) continue;
            Message errorMsg = new Message("UNSUPPORTED_CALLBACK_TYPE", BUNDLE, new Object[]{callbacks[i].getClass().getName()});
            LOG.severe(errorMsg.toString());
            throw new UnsupportedCallbackException(callbacks[i], errorMsg.toString());
        }
    }

    protected boolean handleCallback(Callback callback) {
        return false;
    }

    private boolean invokePasswordCallback(Callback callback) {
        String cbname = this.passwordCallbackName == null ? PASSWORD_CALLBACK_NAME : this.passwordCallbackName;
        for (Class<?> arg : PASSWORD_CALLBACK_TYPES) {
            try {
                Method method = callback.getClass().getMethod(cbname, arg);
                method.invoke((Object)callback, arg == String.class ? this.password : (Object)this.password.toCharArray());
                return true;
            }
            catch (Exception e) {
                LOG.fine(e.toString());
            }
        }
        return false;
    }
}

