/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;

public class BufferHelper {
    public static int sizeOfNullableSimpleString(String str) {
        if (str == null) {
            return 1;
        }
        return 1 + BufferHelper.sizeOfSimpleString(str);
    }

    public static int sizeOfSimpleString(String str) {
        return 4 + str.length() * 2;
    }

    public static void writeAsNullableSimpleString(HornetQBuffer buffer, String str) {
        buffer.writeNullableSimpleString(SimpleString.toSimpleString(str));
    }

    public static String readNullableSimpleStringAsString(HornetQBuffer buffer) {
        SimpleString str = buffer.readNullableSimpleString();
        return str != null ? str.toString() : null;
    }

    public static void writeAsSimpleString(HornetQBuffer buffer, String str) {
        buffer.writeSimpleString(new SimpleString(str));
    }

    public static void writeNullableBoolean(HornetQBuffer buffer, Boolean value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeBoolean(value);
        }
    }

    public static int sizeOfNullableBoolean(Boolean value) {
        return 1 + (value != null ? 1 : 0);
    }

    public static Boolean readNullableBoolean(HornetQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readBoolean();
        }
        return null;
    }

    public static void writeNullableLong(HornetQBuffer buffer, Long value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeLong(value);
        }
    }

    public static void writeNullableDouble(HornetQBuffer buffer, Double value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeDouble(value);
        }
    }

    public static int sizeOfNullableLong(Long value) {
        return 1 + (value != null ? 8 : 0);
    }

    public static int sizeOfNullableDouble(Double value) {
        return 1 + (value != null ? 8 : 0);
    }

    public static Long readNullableLong(HornetQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readLong();
        }
        return null;
    }

    public static void writeNullableInteger(HornetQBuffer buffer, Integer value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeInt(value);
        }
    }

    public static int sizeOfNullableInteger(Integer value) {
        return 1 + (value != null ? 4 : 0);
    }

    public static Integer readNullableInteger(HornetQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readInt();
        }
        return null;
    }

    public static Double readNullableDouble(HornetQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readDouble();
        }
        return null;
    }
}

