/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.facet.index.attributes.CategoryAttribute;
import org.apache.lucene.facet.index.attributes.CategoryAttributeImpl;
import org.apache.lucene.facet.index.attributes.CategoryProperty;
import org.apache.lucene.facet.taxonomy.CategoryPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryContainer
implements Iterable<CategoryAttribute>,
Serializable {
    protected transient Map<CategoryPath, CategoryAttribute> map = new HashMap<CategoryPath, CategoryAttribute>();

    public CategoryAttribute addCategory(CategoryPath categoryPath) {
        return this.mapCategoryAttribute(categoryPath);
    }

    public CategoryAttribute addCategory(CategoryPath categoryPath, CategoryProperty property) {
        CategoryAttribute ca = this.mapCategoryAttribute(categoryPath);
        ca.addProperty(property);
        return ca;
    }

    public CategoryAttribute addCategory(CategoryPath categoryPath, CategoryProperty ... properties) {
        CategoryAttribute ca = this.mapCategoryAttribute(categoryPath);
        for (CategoryProperty attribute : properties) {
            ca.addProperty(attribute);
        }
        return ca;
    }

    public CategoryAttribute addCategory(CategoryAttribute categoryAttribute) {
        CategoryAttribute ca = this.mapCategoryAttribute(categoryAttribute.getCategoryPath());
        Set<Class<? extends CategoryProperty>> propertyClasses = categoryAttribute.getPropertyClasses();
        if (propertyClasses != null) {
            for (Class<? extends CategoryProperty> propertyClass : propertyClasses) {
                ca.addProperty(categoryAttribute.getProperty(propertyClass));
            }
        }
        return ca;
    }

    private final CategoryAttribute mapCategoryAttribute(CategoryPath categoryPath) {
        CategoryAttribute ca = this.map.get(categoryPath);
        if (ca == null) {
            ca = new CategoryAttributeImpl(categoryPath);
            this.map.put(categoryPath, ca);
        }
        return ca;
    }

    public CategoryAttribute getCategoryAttribute(CategoryPath categoryPath) {
        return this.map.get(categoryPath);
    }

    @Override
    public Iterator<CategoryAttribute> iterator() {
        return this.map.values().iterator();
    }

    public void clear() {
        this.map.clear();
    }

    public void merge(CategoryContainer other) {
        for (CategoryAttribute categoryAttribute : other.map.values()) {
            this.addCategory(categoryAttribute);
        }
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CategoryContainer");
        for (CategoryAttribute ca : this.map.values()) {
            builder.append('\n');
            builder.append('\t');
            builder.append(ca.toString());
        }
        return builder.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size());
        for (CategoryAttribute ca : this) {
            this.serializeCategoryAttribute(out, ca);
        }
    }

    protected void serializeCategoryAttribute(ObjectOutputStream out, CategoryAttribute ca) throws IOException {
        out.writeObject(ca.getCategoryPath());
        Set<Class<? extends CategoryProperty>> propertyClasses = ca.getPropertyClasses();
        if (propertyClasses != null) {
            out.writeInt(propertyClasses.size());
            for (Class<? extends CategoryProperty> clazz : propertyClasses) {
                out.writeObject(ca.getProperty(clazz));
            }
        } else {
            out.writeInt(0);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = new HashMap<CategoryPath, CategoryAttribute>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.deserializeCategoryAttribute(in);
        }
    }

    protected void deserializeCategoryAttribute(ObjectInputStream in) throws IOException, ClassNotFoundException {
        CategoryPath cp = (CategoryPath)in.readObject();
        int nProperties = in.readInt();
        if (nProperties == 0) {
            this.addCategory(cp);
        } else {
            for (int j = 0; j < nProperties; ++j) {
                CategoryProperty property = (CategoryProperty)in.readObject();
                this.addCategory(cp, property);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CategoryContainer)) {
            return false;
        }
        CategoryContainer that = (CategoryContainer)o;
        return ((Object)this.map).equals(that.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }
}

