/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.undertow.HttpListenerAdd;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerService;
import org.xnio.OptionMap;

public class HttpsListenerAdd
extends ListenerAdd {
    HttpsListenerAdd(HttpsListenerResourceDefinition def) {
        super(def);
    }

    @Override
    ListenerService<? extends ListenerService> createService(String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder().addAll(listenerOptions);
        HttpsListenerResourceDefinition.VERIFY_CLIENT.resolveOption((ExpressionResolver)context, model, builder);
        HttpsListenerResourceDefinition.ENABLED_CIPHER_SUITES.resolveOption((ExpressionResolver)context, model, builder);
        return new HttpsListenerService(name, serverName, builder.getMap());
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, ServiceBuilder<? extends ListenerService> serviceBuilder, ModelNode model, ListenerService service) throws OperationFailedException {
        serviceBuilder.addDependency(HttpListenerAdd.REGISTRY_SERVICE_NAME, ListenerRegistry.class, ((HttpListenerService)service).getHttpListenerRegistry());
        String securityRealm = HttpsListenerResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model).asString();
        SecurityRealm.ServiceUtil.addDependency(serviceBuilder, ((HttpsListenerService)service).getSecurityRealm(), (String)securityRealm, (boolean)false);
    }
}

