/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.ClientBehaviorPolicyType;
import org.apache.cxf.transport.jms.ClientConfig;
import org.apache.cxf.transport.jms.DestinationStyleType;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSNamingPropertyType;
import org.apache.cxf.transport.jms.JNDIConfiguration;
import org.apache.cxf.transport.jms.ServerBehaviorPolicyType;
import org.apache.cxf.transport.jms.ServerConfig;
import org.apache.cxf.transport.jms.SessionPoolType;
import org.apache.cxf.transport.jms.uri.DeliveryModeType;
import org.apache.cxf.transport.jms.uri.JMSEndpoint;
import org.apache.cxf.transport.jms.uri.JMSEndpointParser;
import org.apache.cxf.transport.jms.uri.JMSURIConstants;
import org.apache.cxf.transport.jms.wsdl.JndiConnectionFactoryNameType;
import org.apache.cxf.transport.jms.wsdl.JndiContextParameterType;
import org.apache.cxf.transport.jms.wsdl.JndiInitialContextFactoryType;
import org.apache.cxf.transport.jms.wsdl.JndiURLType;
import org.apache.cxf.transport.jms.wsdl.PriorityType;
import org.apache.cxf.transport.jms.wsdl.ReplyToNameType;
import org.apache.cxf.transport.jms.wsdl.TimeToLiveType;
import org.apache.cxf.transport.jms.wsdl.TopicReplyToNameType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiTemplate;

public class JMSOldConfigHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSOldConfigHolder.class);
    private ClientConfig clientConfig;
    private ClientBehaviorPolicyType runtimePolicy;
    private SessionPoolType sessionPool;
    private JMSConfiguration jmsConfig;
    private ServerConfig serverConfig;
    private ServerBehaviorPolicyType serverBehavior;
    private AddressType address;

    public void setAddress(AddressType ad) {
        this.address = ad;
    }

    public AddressType getAddress() {
        return this.address;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public ClientBehaviorPolicyType getRuntimePolicy() {
        return this.runtimePolicy;
    }

    public void setRuntimePolicy(ClientBehaviorPolicyType runtimePolicy) {
        this.runtimePolicy = runtimePolicy;
    }

    public SessionPoolType getSessionPool() {
        return this.sessionPool;
    }

    public void setSessionPool(SessionPoolType sessionPool) {
        this.sessionPool = sessionPool;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ServerBehaviorPolicyType getServerBehavior() {
        return this.serverBehavior;
    }

    public void setServerBehavior(ServerBehaviorPolicyType serverBehavior) {
        this.serverBehavior = serverBehavior;
    }

    protected JMSEndpoint getExtensorsAndConfig(Bus bus, EndpointInfo endpointInfo, EndpointReferenceType target, boolean isConduit) throws IOException {
        JMSEndpoint endpoint = null;
        String adr = target == null ? endpointInfo.getAddress() : target.getAddress().getValue();
        try {
            endpoint = StringUtils.isEmpty((String)adr) || "jms://".equals(adr) || !adr.startsWith("jms") ? new JMSEndpoint() : JMSEndpointParser.createEndpoint(adr);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            IOException e2 = new IOException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        this.retrieveWSDLInformation(endpoint, endpointInfo);
        this.address = (AddressType)((Object)endpointInfo.getTraversedExtensor((Object)this.address, AddressType.class));
        this.clientConfig = (ClientConfig)((Object)endpointInfo.getTraversedExtensor((Object)new ClientConfig(), ClientConfig.class));
        this.runtimePolicy = (ClientBehaviorPolicyType)((Object)endpointInfo.getTraversedExtensor((Object)new ClientBehaviorPolicyType(), ClientBehaviorPolicyType.class));
        this.serverConfig = (ServerConfig)((Object)endpointInfo.getTraversedExtensor((Object)new ServerConfig(), ServerConfig.class));
        this.sessionPool = (SessionPoolType)((Object)endpointInfo.getTraversedExtensor((Object)new SessionPoolType(), SessionPoolType.class));
        this.serverBehavior = (ServerBehaviorPolicyType)((Object)endpointInfo.getTraversedExtensor((Object)new ServerBehaviorPolicyType(), ServerBehaviorPolicyType.class));
        String name = endpointInfo.getName() == null ? null : endpointInfo.getName().toString() + (isConduit ? ".jms-conduit" : ".jms-destination");
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        if (null != configurer) {
            if (name != null) {
                configurer.configureBean(name, (Object)this);
            }
            if (adr != null) {
                configurer.configureBean(adr, (Object)this);
            }
        }
        return endpoint;
    }

    public JMSConfiguration createJMSConfigurationFromEndpointInfo(Bus bus, EndpointInfo endpointInfo, EndpointReferenceType target, boolean isConduit) throws IOException {
        JMSEndpoint endpoint = this.getExtensorsAndConfig(bus, endpointInfo, target, isConduit);
        return this.configureEndpoint(isConduit, endpoint);
    }

    protected JMSConfiguration configureEndpoint(boolean isConduit, JMSEndpoint endpoint) {
        if (this.address != null) {
            JMSOldConfigHolder.mapAddressToEndpoint(this.address, endpoint);
        }
        if (this.jmsConfig == null) {
            this.jmsConfig = new JMSConfiguration();
        }
        if (endpoint.isSetDeliveryMode()) {
            int deliveryMode = endpoint.getDeliveryMode().equals((Object)JMSURIConstants.DELIVERYMODE_PERSISTENT) ? 2 : 1;
            this.jmsConfig.setDeliveryMode(deliveryMode);
        }
        if (endpoint.isSetPriority()) {
            int priority = endpoint.getPriority();
            this.jmsConfig.setPriority(priority);
        }
        if (this.jmsConfig.isUsingEndpointInfo()) {
            boolean useJndi;
            JndiTemplate jt = new JndiTemplate();
            jt.setEnvironment(JMSOldConfigHolder.getInitialContextEnv(endpoint));
            boolean pubSubDomain = endpoint.getJmsVariant().contains("topic");
            JNDIConfiguration jndiConfig = new JNDIConfiguration();
            jndiConfig.setJndiConnectionFactoryName(endpoint.getJndiConnectionFactoryName());
            this.jmsConfig.setJndiTemplate(jt);
            jndiConfig.setConnectionUserName(endpoint.getUsername());
            jndiConfig.setConnectionPassword(endpoint.getPassword());
            this.jmsConfig.setJndiConfig(jndiConfig);
            if (endpoint.isSetReconnectOnException()) {
                this.jmsConfig.setReconnectOnException(endpoint.isReconnectOnException());
            }
            this.jmsConfig.setDurableSubscriptionName(this.serverBehavior.getDurableSubscriberName());
            this.jmsConfig.setExplicitQosEnabled(true);
            if (this.jmsConfig.getMessageSelector() == null) {
                this.jmsConfig.setMessageSelector(this.serverBehavior.getMessageSelector());
            }
            if (isConduit) {
                if (this.runtimePolicy.isSetMessageType()) {
                    this.jmsConfig.setMessageType(this.runtimePolicy.getMessageType().value());
                } else if (this.address == null) {
                    if (endpoint.getMessageType() == null) {
                        this.jmsConfig.setMessageType("byte");
                    } else {
                        this.jmsConfig.setMessageType(endpoint.getMessageType().value());
                    }
                }
            }
            this.jmsConfig.setPubSubDomain(pubSubDomain);
            this.jmsConfig.setPubSubNoLocal(true);
            if (this.clientConfig.isSetClientReceiveTimeout()) {
                this.jmsConfig.setReceiveTimeout(this.clientConfig.getClientReceiveTimeout());
            }
            if (this.clientConfig.isSetUseConduitIdSelector()) {
                this.jmsConfig.setUseConduitIdSelector(this.clientConfig.isUseConduitIdSelector());
            }
            if (this.clientConfig.isSetConduitSelectorPrefix()) {
                this.jmsConfig.setConduitSelectorPrefix(this.clientConfig.getConduitSelectorPrefix());
            }
            if (this.serverConfig.isSetServerReceiveTimeout()) {
                this.jmsConfig.setServerReceiveTimeout(this.serverConfig.getServerReceiveTimeout());
            }
            this.jmsConfig.setEnforceSpec(this.clientConfig.isEnforceSpec());
            this.jmsConfig.setSubscriptionDurable(this.serverBehavior.isSetDurableSubscriberName());
            this.jmsConfig.setDurableSubscriptionName(this.serverBehavior.getDurableSubscriberName());
            this.jmsConfig.setDurableSubscriptionClientId(this.serverConfig.getDurableSubscriptionClientId());
            if (this.sessionPool.isSetHighWaterMark()) {
                this.jmsConfig.setMaxConcurrentConsumers(this.sessionPool.getHighWaterMark());
            }
            if (this.sessionPool.isSetLowWaterMark()) {
                this.jmsConfig.setConcurrentConsumers(this.sessionPool.getLowWaterMark());
            }
            if (endpoint.isSetTimeToLive()) {
                long timeToLive = endpoint.getTimeToLive();
                this.jmsConfig.setTimeToLive(timeToLive);
            }
            if (endpoint.isSetUseJMS11()) {
                this.jmsConfig.setUseJms11(endpoint.isUseJMS11());
            }
            if (this.serverBehavior.isSetTransactional()) {
                this.jmsConfig.setSessionTransacted(this.serverBehavior.isTransactional());
            }
            if (useJndi = endpoint.getJmsVariant().contains("jndi")) {
                JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
                jndiDestinationResolver.setJndiTemplate(jt);
                this.jmsConfig.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
                this.jmsConfig.setTargetDestination(endpoint.getDestinationName());
                JMSOldConfigHolder.setReplyDestination(this.jmsConfig, endpoint);
                if (this.address != null) {
                    this.jmsConfig.setReplyToDestination(this.address.getJndiReplyToDestinationName());
                }
            } else {
                this.jmsConfig.setTargetDestination(endpoint.getDestinationName());
                JMSOldConfigHolder.setReplyDestination(this.jmsConfig, endpoint);
                if (this.address != null) {
                    this.jmsConfig.setReplyToDestination(this.address.getJmsReplyToDestinationName());
                }
            }
        }
        String requestURI = endpoint.getRequestURI();
        this.jmsConfig.setRequestURI(requestURI);
        String targetService = endpoint.getParameter("targetService");
        this.jmsConfig.setTargetService(targetService);
        return this.jmsConfig;
    }

    private static void setReplyDestination(JMSConfiguration jmsConfig, JMSEndpoint endpoint) {
        if (endpoint.getReplyToName() != null) {
            jmsConfig.setReplyDestination(endpoint.getReplyToName());
            jmsConfig.setReplyPubSubDomain(false);
        } else if (endpoint.getTopicReplyToName() != null) {
            jmsConfig.setReplyDestination(endpoint.getTopicReplyToName());
            jmsConfig.setReplyPubSubDomain(true);
        }
    }

    private static void mapAddressToEndpoint(AddressType address, JMSEndpoint endpoint) {
        boolean useJndi;
        boolean pubSubDomain;
        boolean bl = pubSubDomain = DestinationStyleType.TOPIC == address.getDestinationStyle();
        if (address.isSetDestinationStyle()) {
            endpoint.setJmsVariant(pubSubDomain ? "topic" : "queue");
        } else {
            endpoint.setJmsVariant("queue");
        }
        if (address.isSetJndiConnectionFactoryName()) {
            endpoint.setJndiConnectionFactoryName(address.getJndiConnectionFactoryName());
        }
        if (address.isSetConnectionUserName()) {
            endpoint.setUsername(address.getConnectionUserName());
        }
        if (address.isSetConnectionPassword()) {
            endpoint.setPassword(address.getConnectionPassword());
        }
        if (address.isSetReconnectOnException()) {
            endpoint.setReconnectOnException(address.isReconnectOnException());
        }
        if (address.isSetUseJms11()) {
            endpoint.setUseJMS11(address.isUseJms11());
        }
        if (useJndi = address.isSetJndiDestinationName()) {
            endpoint.setJmsVariant(pubSubDomain ? "jndi-topic" : "jndi");
            endpoint.setDestinationName(address.getJndiDestinationName());
            endpoint.setReplyToName(address.getJndiReplyDestinationName());
        } else {
            endpoint.setDestinationName(address.getJmsDestinationName());
            endpoint.setReplyToName(address.getJmsReplyDestinationName());
        }
        ListIterator<JMSNamingPropertyType> listIter = address.getJMSNamingProperty().listIterator();
        while (listIter.hasNext()) {
            JMSNamingPropertyType propertyPair = listIter.next();
            if (null == propertyPair.getValue()) continue;
            endpoint.putJndiParameter(propertyPair.getName(), propertyPair.getValue());
        }
    }

    private void retrieveWSDLInformation(JMSEndpoint endpoint, EndpointInfo ei) {
        TopicReplyToNameType topicReplyToNameType;
        ReplyToNameType replyToNameType;
        TimeToLiveType timeToLiveType;
        PriorityType priorityType;
        org.apache.cxf.transport.jms.wsdl.DeliveryModeType deliveryModeType;
        JndiURLType jndiURLType;
        JndiInitialContextFactoryType jndiInitialContextFactoryType;
        JndiConnectionFactoryNameType jndiConnectionFactoryNameType;
        JndiContextParameterType jndiContextParameterType = this.getWSDLExtensor(ei, JndiContextParameterType.class);
        if (jndiContextParameterType != null && endpoint.getJndiParameters().get(jndiContextParameterType.getName()) == null) {
            endpoint.putJndiParameter(jndiContextParameterType.getName().trim(), jndiContextParameterType.getValue().trim());
        }
        if (!endpoint.isSetJndiConnectionFactoryName() && (jndiConnectionFactoryNameType = this.getWSDLExtensor(ei, JndiConnectionFactoryNameType.class)) != null) {
            endpoint.setJndiConnectionFactoryName(jndiConnectionFactoryNameType.getValue().trim());
        }
        if (!endpoint.isSetJndiInitialContextFactory() && (jndiInitialContextFactoryType = this.getWSDLExtensor(ei, JndiInitialContextFactoryType.class)) != null) {
            endpoint.setJndiInitialContextFactory(jndiInitialContextFactoryType.getValue().trim());
        }
        if (!endpoint.isSetJndiURL() && (jndiURLType = this.getWSDLExtensor(ei, JndiURLType.class)) != null) {
            endpoint.setJndiURL(jndiURLType.getValue().trim());
        }
        if (!endpoint.isSetDeliveryMode() && (deliveryModeType = this.getWSDLExtensor(ei, org.apache.cxf.transport.jms.wsdl.DeliveryModeType.class)) != null) {
            String deliveryMode = deliveryModeType.getValue().trim();
            endpoint.setDeliveryMode(DeliveryModeType.valueOf(deliveryMode));
        }
        if (!endpoint.isSetPriority() && (priorityType = this.getWSDLExtensor(ei, PriorityType.class)) != null) {
            endpoint.setPriority(priorityType.getValue());
        }
        if (!endpoint.isSetTimeToLive() && (timeToLiveType = this.getWSDLExtensor(ei, TimeToLiveType.class)) != null) {
            endpoint.setTimeToLive(timeToLiveType.getValue());
        }
        if (!endpoint.isSetReplyToName() && (replyToNameType = this.getWSDLExtensor(ei, ReplyToNameType.class)) != null) {
            endpoint.setReplyToName(replyToNameType.getValue());
        }
        if (!endpoint.isSetTopicReplyToName() && (topicReplyToNameType = this.getWSDLExtensor(ei, TopicReplyToNameType.class)) != null) {
            endpoint.setTopicReplyToName(topicReplyToNameType.getValue());
        }
    }

    public <T> T getWSDLExtensor(EndpointInfo ei, Class<T> cls) {
        ServiceInfo si = ei.getService();
        BindingInfo bi = ei.getBinding();
        Object o = ei.getExtensor(cls);
        if (o == null && si != null) {
            o = si.getExtensor(cls);
        }
        if (o == null && bi != null) {
            o = bi.getExtensor(cls);
        }
        if (o == null) {
            return null;
        }
        if (cls.isInstance(o)) {
            return cls.cast(o);
        }
        return null;
    }

    public static Properties getInitialContextEnv(JMSEndpoint endpoint) {
        Properties env = new Properties();
        if (endpoint.isSetJndiInitialContextFactory()) {
            env.put("java.naming.factory.initial", endpoint.getJndiInitialContextFactory());
        }
        if (endpoint.isSetJndiURL()) {
            env.put("java.naming.provider.url", endpoint.getJndiURL());
        }
        for (Map.Entry<String, String> ent : endpoint.getJndiParameters().entrySet()) {
            env.put(ent.getKey(), ent.getValue());
        }
        if (LOG.isLoggable(Level.FINE)) {
            Enumeration<?> props = env.propertyNames();
            while (props.hasMoreElements()) {
                String name = (String)props.nextElement();
                String value = env.getProperty(name);
                LOG.log(Level.FINE, "Context property: " + name + " | " + value);
            }
        }
        return env;
    }
}

