/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.RouteLocatorService;
import org.wildfly.clustering.web.infinispan.session.SessionCacheConfigurationService;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilder;

public class InfinispanSessionManagerFactoryBuilder
implements SessionManagerFactoryBuilder {
    public static final String DEFAULT_CACHE_CONTAINER = "web";

    public ServiceBuilder<SessionManagerFactory> buildDeploymentDependency(ServiceTarget target, ServiceName name, ServiceName deploymentServiceName, Module module, JBossWebMetaData metaData) {
        ServiceName templateCacheServiceName = InfinispanSessionManagerFactoryBuilder.getCacheServiceName(metaData.getReplicationConfig());
        String templateCacheName = templateCacheServiceName.getSimpleName();
        ServiceName containerServiceName = templateCacheServiceName.getParent();
        String containerName = containerServiceName.getSimpleName();
        String host = deploymentServiceName.getParent().getSimpleName();
        String contextPath = deploymentServiceName.getSimpleName();
        StringBuilder cacheNameBuilder = new StringBuilder(host).append(contextPath);
        if (contextPath.isEmpty() || contextPath.equals("/")) {
            cacheNameBuilder.append("ROOT");
        }
        String cacheName = cacheNameBuilder.toString();
        ServiceName cacheConfigurationServiceName = CacheConfigurationService.getServiceName((String)containerName, (String)cacheName);
        ServiceName cacheServiceName = CacheService.getServiceName((String)containerName, (String)cacheName);
        SessionCacheConfigurationService.build(target, containerName, cacheName, templateCacheName, metaData).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        final InjectedValue cacheContainer = new InjectedValue();
        CacheService.Dependencies dependencies = new CacheService.Dependencies(){

            public EmbeddedCacheManager getCacheContainer() {
                return (EmbeddedCacheManager)cacheContainer.getValue();
            }

            public XAResourceRecoveryRegistry getRecoveryRegistry() {
                return null;
            }
        };
        AsynchronousService.addService((ServiceTarget)target, (ServiceName)cacheServiceName, (Service)new CacheService(cacheName, dependencies)).addAliases(new ServiceName[]{RouteLocatorService.getCacheServiceName(deploymentServiceName)}).addDependency(cacheConfigurationServiceName).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)cacheContainer).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        InjectedValue cache = new InjectedValue();
        InjectedValue affinityFactory = new InjectedValue();
        InfinispanSessionManagerFactory factory = new InfinispanSessionManagerFactory(module, metaData, (Value<Cache>)cache, (Value<KeyAffinityServiceFactory>)affinityFactory);
        return target.addService(name, (Service)factory).addDependency(cacheServiceName, Cache.class, (Injector)cache).addDependency(KeyAffinityServiceFactoryService.getServiceName((String)containerName), KeyAffinityServiceFactory.class, (Injector)affinityFactory);
    }

    private static ServiceName getCacheServiceName(ReplicationConfig config) {
        String cacheName;
        ServiceName serviceName;
        ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)((cacheName = config != null ? config.getCacheName() : null) != null ? cacheName : DEFAULT_CACHE_CONTAINER)))) {
            serviceName = baseServiceName.append(serviceName);
        }
        return serviceName.length() < 4 ? serviceName.append(new String[]{"default"}) : serviceName;
    }
}

