/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;

public class InfinispanSSOManager<V, I, D, L>
implements SSOManager<I, D, L> {
    private final SSOFactory<V, I, D, L> factory;
    private final Batcher batcher;
    private final IdentifierFactory<String> identifierFactory;

    public InfinispanSSOManager(SSOFactory<V, I, D, L> factory, IdentifierFactory<String> identifierFactory, Batcher batcher) {
        this.factory = factory;
        this.batcher = batcher;
        this.identifierFactory = identifierFactory;
    }

    public SSO<I, D, L> createSSO(String ssoId) {
        return this.factory.createSSO(ssoId, this.factory.createValue(ssoId));
    }

    public SSO<I, D, L> findSSO(String ssoId) {
        Object value = this.factory.findValue(ssoId);
        return value != null ? this.factory.createSSO(ssoId, value) : null;
    }

    public Batcher getBatcher() {
        return this.batcher;
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public void start() {
        this.identifierFactory.start();
    }

    public void stop() {
        this.identifierFactory.stop();
    }
}

