/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Creator;
import org.jboss.as.clustering.infinispan.invoker.Locator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.CacheEntryMutator;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSO;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseAuthentication;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseAuthenticationEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsKey;
import org.wildfly.clustering.web.sso.SSO;

public class CoarseSSOFactory<I, D, L>
implements SSOFactory<CoarseSSOEntry<I, D, L>, I, D, L> {
    private final Cache<String, CoarseAuthenticationEntry<I, D, L>> authenticationCache;
    private final Cache<CoarseSessionsKey, Map<D, String>> sessionsCache;
    private final CacheInvoker invoker;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSSOFactory(Cache<String, CoarseAuthenticationEntry<I, D, L>> authenticationCache, Cache<CoarseSessionsKey, Map<D, String>> sessionsCache, CacheInvoker invoker, LocalContextFactory<L> localContextFactory) {
        this.authenticationCache = authenticationCache;
        this.sessionsCache = sessionsCache;
        this.invoker = invoker;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public SSO<I, D, L> createSSO(String id, CoarseSSOEntry<I, D, L> entry) {
        CoarseAuthenticationEntry<I, D, L> authenticationEntry = entry.getAuthenticationEntry();
        CacheEntryMutator<String, CoarseAuthenticationEntry<I, D, L>> authenticationMutator = new CacheEntryMutator<String, CoarseAuthenticationEntry<I, D, L>>(this.authenticationCache, this.invoker, id, authenticationEntry, new Flag[0]);
        CoarseAuthentication<I> authentication = new CoarseAuthentication<I>(authenticationEntry, authenticationMutator);
        CoarseSessionsKey sessionsKey = new CoarseSessionsKey(id);
        Map<D, String> sessionsValue = entry.getSessions();
        CacheEntryMutator<CoarseSessionsKey, Map<D, String>> sessionsMutator = new CacheEntryMutator<CoarseSessionsKey, Map<D, String>>(this.sessionsCache, this.invoker, sessionsKey, sessionsValue, new Flag[0]);
        CoarseSessions<D> sessions = new CoarseSessions<D>(sessionsValue, sessionsMutator);
        return new InfinispanSSO<I, D, L>(id, authentication, sessions, authenticationEntry.getLocalContext(), this.localContextFactory, this);
    }

    public CoarseSSOEntry<I, D, L> createValue(String id) {
        CoarseAuthenticationEntry entry = new CoarseAuthenticationEntry();
        CoarseAuthenticationEntry existingEntry = (CoarseAuthenticationEntry)this.invoker.invoke(this.authenticationCache, (CacheInvoker.Operation)new Creator.CreateOperation((Object)id, entry), new Flag[0]);
        if (existingEntry != null) {
            Map value = (Map)this.invoker.invoke(this.sessionsCache, (CacheInvoker.Operation)new Locator.FindOperation((Object)new CoarseSessionsKey(id)), new Flag[]{Flag.SKIP_LOCKING});
            return new CoarseSSOEntry(existingEntry, value);
        }
        HashMap map = new HashMap();
        HashMap existingMap = (HashMap)this.invoker.invoke(this.sessionsCache, (CacheInvoker.Operation)new Creator.CreateOperation((Object)new CoarseSessionsKey(id), map), new Flag[]{Flag.SKIP_LOCKING});
        return new CoarseSSOEntry(entry, existingMap != null ? existingMap : map);
    }

    public CoarseSSOEntry<I, D, L> findValue(String id) {
        CoarseAuthenticationEntry entry = (CoarseAuthenticationEntry)this.invoker.invoke(this.authenticationCache, (CacheInvoker.Operation)new Locator.FindOperation((Object)id), new Flag[0]);
        if (entry == null) {
            return null;
        }
        Map map = (Map)this.invoker.invoke(this.sessionsCache, (CacheInvoker.Operation)new Locator.FindOperation((Object)new CoarseSessionsKey(id)), new Flag[]{Flag.SKIP_LOCKING});
        return new CoarseSSOEntry(entry, map);
    }

    public void remove(String id) {
        this.invoker.invoke(this.authenticationCache, (CacheInvoker.Operation)new Remover.RemoveOperation((Object)id), new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.invoker.invoke(this.sessionsCache, (CacheInvoker.Operation)new Remover.RemoveOperation((Object)new CoarseSessionsKey(id)), new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LOCKING});
    }
}

