/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class CaseInsensitiveMap<V>
implements MultivaluedMap<String, V>,
Serializable {
    private MultivaluedMap<CaseInsensitiveKey, V> map = new MultivaluedHashMap();

    public void putSingle(String key, V value) {
        this.map.putSingle((Object)new CaseInsensitiveKey(key), value);
    }

    public void add(String key, V value) {
        this.map.add((Object)new CaseInsensitiveKey(key), value);
    }

    public V getFirst(String key) {
        return (V)this.map.getFirst((Object)new CaseInsensitiveKey(key));
    }

    public final int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object o) {
        String key = o == null ? null : o.toString();
        return this.map.containsKey((Object)new CaseInsensitiveKey(key));
    }

    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    public List<V> get(Object o) {
        String key = o == null ? null : o.toString();
        return (List)this.map.get((Object)new CaseInsensitiveKey(key));
    }

    public List<V> put(String s, List<V> vs) {
        return (List)this.map.put((Object)new CaseInsensitiveKey(s), vs);
    }

    public List<V> remove(Object o) {
        String key = o == null ? null : o.toString();
        return (List)this.map.remove((Object)new CaseInsensitiveKey(key));
    }

    private List<V> getMapList(CaseInsensitiveKey key) {
        ArrayList list = (ArrayList)this.map.get((Object)key);
        if (list == null) {
            list = new ArrayList();
            this.map.put((Object)key, list);
        }
        return list;
    }

    public final void putAll(Map otherMap) {
        if (otherMap instanceof CaseInsensitiveMap) {
            CaseInsensitiveMap otherCaseInsensitiveMap = (CaseInsensitiveMap)((Object)otherMap);
            Set es = otherCaseInsensitiveMap.map.entrySet();
            for (Map.Entry entry : es) {
                this.getMapList((CaseInsensitiveKey)entry.getKey()).addAll((Collection)entry.getValue());
            }
        } else {
            for (Map.Entry entry : otherMap.entrySet()) {
                this.getMapList(new CaseInsensitiveKey((String)entry.getKey())).addAll((Collection)entry.getValue());
            }
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<String> keySet() {
        return new KeySetWrapper(this.map.keySet());
    }

    public Collection<List<V>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, List<V>>> entrySet() {
        return new EntrySetWrapper<List<V>>(this.map.entrySet());
    }

    public void addAll(String key, V ... newValues) {
        for (V value : newValues) {
            this.add(key, value);
        }
    }

    public void addAll(String key, List<V> valueList) {
        for (V value : valueList) {
            this.add(key, value);
        }
    }

    public void addFirst(String key, V value) {
        Object list = this.get(key);
        if (list == null) {
            this.add(key, value);
            return;
        }
        list.add(0, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, V> omap) {
        if (this == omap) {
            return true;
        }
        if (!this.keySet().equals(omap.keySet())) {
            return false;
        }
        for (Map.Entry<String, List<V>> e : this.entrySet()) {
            List olist = (List)omap.get((Object)e.getKey());
            if (e.getValue().size() != olist.size()) {
                return false;
            }
            for (V v : e.getValue()) {
                if (olist.contains(v)) continue;
                return false;
            }
        }
        return true;
    }

    private static class CaseInsensitiveKey
    implements Serializable {
        private static final long serialVersionUID = 6249456709345532524L;
        private String key;
        private String tlc;
        private int hashCode = 0;

        private CaseInsensitiveKey(String key) {
            this.key = key;
            if (key != null) {
                this.tlc = key.toLowerCase();
                this.hashCode = this.tlc.hashCode();
            }
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaseInsensitiveKey that = (CaseInsensitiveKey)o;
            if (this.tlc == that.tlc) {
                return true;
            }
            if (this.tlc == null || that.tlc == null) {
                return false;
            }
            return this.tlc.equals(that.tlc);
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final String toString() {
            return this.key;
        }
    }

    private static class EntrySetWrapper<V>
    implements Set<Map.Entry<String, V>> {
        private Set<Map.Entry<CaseInsensitiveKey, V>> entrySet;

        private EntrySetWrapper(Set<Map.Entry<CaseInsensitiveKey, V>> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.entrySet.contains(new EntryWrapper((Map.Entry)o));
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new Iterator<Map.Entry<String, V>>(){
                Iterator<Map.Entry<CaseInsensitiveKey, V>> it;
                {
                    this.it = EntrySetWrapper.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<String, V> next() {
                    return new EntryDelegate(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Map.Entry[] array = new Map.Entry[this.entrySet.size()];
            return this.toArray(array);
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            Map.Entry[] array = (Map.Entry[])ts;
            int i = 0;
            for (Map.Entry<CaseInsensitiveKey, V> entry : this.entrySet) {
                array[i++] = new EntryDelegate(entry);
            }
            return array;
        }

        @Override
        public boolean add(Map.Entry<String, V> stringVEntry) {
            this.entrySet.add(new EntryWrapper<V>(stringVEntry));
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return this.entrySet.remove(new EntryWrapper((Map.Entry)o));
        }

        @Override
        public boolean containsAll(Collection<?> objects) {
            Collection<?> list = objects;
            HashSet set = new HashSet();
            for (Map.Entry entry : list) {
                set.add(new EntryWrapper(entry));
            }
            return this.entrySet.containsAll(set);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, V>> entries) {
            HashSet<EntryWrapper<V>> set = new HashSet<EntryWrapper<V>>();
            for (Map.Entry<String, V> entry : entries) {
                set.add(new EntryWrapper<V>(entry));
            }
            return this.entrySet.addAll(set);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            Collection<?> list = objects;
            HashSet set = new HashSet();
            for (Map.Entry entry : list) {
                set.add(new EntryWrapper(entry));
            }
            return this.entrySet.retainAll(set);
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            Collection<?> list = objects;
            HashSet set = new HashSet();
            for (Map.Entry entry : list) {
                set.add(new EntryWrapper(entry));
            }
            return this.entrySet.removeAll(set);
        }

        @Override
        public void clear() {
            this.entrySet.clear();
        }

        private class EntryDelegate<T>
        implements Map.Entry<String, T> {
            private Map.Entry<CaseInsensitiveKey, T> entry;

            private EntryDelegate(Map.Entry<CaseInsensitiveKey, T> entry) {
                this.entry = entry;
            }

            @Override
            public final String getKey() {
                return this.entry.getKey().key;
            }

            @Override
            public final T getValue() {
                return this.entry.getValue();
            }

            @Override
            public final T setValue(T v) {
                return this.entry.setValue(v);
            }
        }

        private class EntryWrapper<T>
        implements Map.Entry<CaseInsensitiveKey, T> {
            private CaseInsensitiveKey key;
            private T value;

            public EntryWrapper(Map.Entry<String, T> entry) {
                this.key = new CaseInsensitiveKey(entry.getKey());
                this.value = entry.getValue();
            }

            @Override
            public CaseInsensitiveKey getKey() {
                return this.key;
            }

            @Override
            public T getValue() {
                return this.value;
            }

            @Override
            public T setValue(T v) {
                T tmp = this.value;
                this.value = v;
                return tmp;
            }
        }
    }

    private static class KeySetWrapper
    implements Set<String> {
        private Set<CaseInsensitiveKey> keys;

        public KeySetWrapper(Set<CaseInsensitiveKey> keys) {
            this.keys = keys;
        }

        @Override
        public int size() {
            return this.keys.size();
        }

        @Override
        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.keys.contains(new CaseInsensitiveKey((String)o));
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private Iterator<CaseInsensitiveKey> it;
                {
                    this.it = KeySetWrapper.this.keys.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public String next() {
                    return this.it.next().key;
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new String[this.keys.size()]);
        }

        @Override
        public <T> T[] toArray(T[] ks) {
            int i = 0;
            for (CaseInsensitiveKey key : this.keys) {
                ks[i++] = key.key;
            }
            return ks;
        }

        @Override
        public boolean add(String key) {
            return this.keys.add(new CaseInsensitiveKey(key));
        }

        @Override
        public boolean remove(Object o) {
            return this.keys.remove(new CaseInsensitiveKey(o.toString()));
        }

        @Override
        public boolean containsAll(Collection<?> objects) {
            HashSet<CaseInsensitiveKey> objs = new HashSet<CaseInsensitiveKey>();
            for (Object o : objects) {
                objs.add(new CaseInsensitiveKey(o.toString()));
            }
            return this.keys.containsAll(objs);
        }

        @Override
        public boolean addAll(Collection<? extends String> objects) {
            HashSet<CaseInsensitiveKey> objs = new HashSet<CaseInsensitiveKey>();
            for (String string : objects) {
                objs.add(new CaseInsensitiveKey(string.toString()));
            }
            return this.keys.addAll(objs);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            HashSet<CaseInsensitiveKey> objs = new HashSet<CaseInsensitiveKey>();
            for (Object o : objects) {
                objs.add(new CaseInsensitiveKey(o.toString()));
            }
            return this.keys.retainAll(objects);
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            HashSet<CaseInsensitiveKey> objs = new HashSet<CaseInsensitiveKey>();
            for (Object o : objects) {
                objs.add(new CaseInsensitiveKey(o.toString()));
            }
            return this.keys.removeAll(objects);
        }

        @Override
        public void clear() {
            this.keys.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Set)) {
                return false;
            }
            Set strings = (Set)o;
            if (this.size() != strings.size()) {
                return false;
            }
            for (String string : strings) {
                if (this.contains(string)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.keys.hashCode();
        }
    }
}

