/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.parsers.wsa.WSAddressingParser;
import org.picketlink.identity.federation.core.parsers.wsp.WSPolicyParser;
import org.picketlink.identity.federation.core.parsers.wsse.WSSecurityParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTCancelTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRenewTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenCollectionParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTValidateTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTrustOnBehalfOfParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTrustParser;

public class ParserController {
    private static List<ParserNamespaceSupport> parsers = new ArrayList<ParserNamespaceSupport>();
    private static RuntimePermission PARSER_PERM = new RuntimePermission("org.picketlink.parser.permission");

    public static void add(ParserNamespaceSupport parser) {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(PARSER_PERM);
        }
        parsers.add(0, parser);
    }

    public static ParserNamespaceSupport get(QName qname) {
        int size = parsers.size();
        if (size > 0) {
            for (ParserNamespaceSupport parser : parsers) {
                if (!parser.supports(qname)) continue;
                return parser;
            }
        }
        return null;
    }

    public static void clearAll() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(PARSER_PERM);
        }
        parsers.clear();
    }

    static {
        ParserController.add((ParserNamespaceSupport)new SAMLParser());
        ParserController.add((ParserNamespaceSupport)new WSTrustParser());
        ParserController.add((ParserNamespaceSupport)new WSSecurityParser());
        ParserController.add((ParserNamespaceSupport)new WSPolicyParser());
        ParserController.add((ParserNamespaceSupport)new WSAddressingParser());
        ParserController.add(new WSTrustOnBehalfOfParser());
        ParserController.add(new WSTValidateTargetParser());
        ParserController.add(new WSTRenewTargetParser());
        ParserController.add(new WSTCancelTargetParser());
        ParserController.add(new WSTRequestSecurityTokenParser());
        ParserController.add(new WSTRequestSecurityTokenCollectionParser());
    }
}

