/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.wsse.WSSecurityParser;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;

public class WSTrustOnBehalfOfParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        OnBehalfOfType onBehalfType = new OnBehalfOfType();
        StartElement startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
        String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
        if (!tag.equals("UsernameToken")) {
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        WSSecurityParser wsseParser = new WSSecurityParser();
        UsernameTokenType userNameToken = (UsernameTokenType)wsseParser.parse(xmlEventReader);
        onBehalfType.add(userNameToken);
        return onBehalfType;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(nsURI) && "OnBehalfOf".equals(localPart);
    }
}

