/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Set;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;

public class ClusteredCacheLoaderInterceptor
extends CacheLoaderInterceptor {
    private boolean isWriteSkewConfigured;
    private ClusteringDependentLogic cdl;
    private DistributionManager dm;

    @Inject
    private void injectDependencies(ClusteringDependentLogic cdl, DistributionManager dm) {
        this.cdl = cdl;
        this.dm = dm;
    }

    @Start(priority=15)
    private void startClusteredCacheLoaderInterceptor() {
        CacheMode cacheMode = this.cacheConfiguration.clustering().cacheMode();
        this.isWriteSkewConfigured = this.cacheConfiguration.locking().writeSkewCheck() && (cacheMode.isReplicated() || cacheMode.isDistributed());
    }

    @Override
    protected boolean forceLoad(Object key, Set<Flag> flags) {
        return this.isDeltaWrite(flags) || this.isWriteSkewConfigured && this.cdl.localNodeIsPrimaryOwner(key);
    }

    @Override
    protected boolean canLoad(Object key) {
        return !this.cacheConfiguration.clustering().cacheMode().isDistributed() || this.dm.getReadConsistentHash().isKeyLocalToNode(this.cdl.getAddress(), key);
    }
}

