/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.serialization.impl.LuceneWorkHydrator;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.spi.Deserializer;
import org.hibernate.search.indexes.serialization.spi.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.spi.LuceneNumericFieldContext;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.spi.Serializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PluggableSerializationLuceneWorkSerializer
implements LuceneWorkSerializer {
    private static Log log = LoggerFactory.make();
    private final SearchFactoryImplementor searchFactory;
    private SerializationProvider provider;

    public PluggableSerializationLuceneWorkSerializer(SerializationProvider provider, SearchFactoryImplementor searchFactory) {
        this.provider = provider;
        this.searchFactory = searchFactory;
    }

    @Override
    public byte[] toSerializedModel(List<LuceneWork> works) {
        try {
            Serializer serializer = this.provider.getSerializer();
            serializer.luceneWorks(works);
            for (LuceneWork work : works) {
                if (work instanceof OptimizeLuceneWork) {
                    serializer.addOptimizeAll();
                    continue;
                }
                if (work instanceof PurgeAllLuceneWork) {
                    serializer.addPurgeAll(work.getEntityClass().getName());
                    continue;
                }
                if (work instanceof DeleteLuceneWork) {
                    this.processId(work, serializer);
                    serializer.addDelete(work.getEntityClass().getName());
                    continue;
                }
                if (work instanceof AddLuceneWork) {
                    this.buildDocument(work.getDocument(), serializer);
                    this.processId(work, serializer);
                    serializer.addAdd(work.getEntityClass().getName(), work.getFieldToAnalyzerMap());
                    continue;
                }
                if (!(work instanceof UpdateLuceneWork)) continue;
                this.buildDocument(work.getDocument(), serializer);
                this.processId(work, serializer);
                serializer.addUpdate(work.getEntityClass().getName(), work.getFieldToAnalyzerMap());
            }
            return serializer.serialize();
        }
        catch (RuntimeException e) {
            if (e instanceof SearchException) {
                throw e;
            }
            throw log.unableToSerializeLuceneWorks(e);
        }
    }

    private void processId(LuceneWork work, Serializer serializer) {
        Serializable id = work.getId();
        if (id instanceof Integer) {
            serializer.addIdAsInteger((Integer)id);
        } else if (id instanceof Long) {
            serializer.addIdAsLong((Long)id);
        } else if (id instanceof Float) {
            serializer.addIdAsFloat(((Float)id).floatValue());
        } else if (id instanceof Double) {
            serializer.addIdAsDouble((Double)id);
        } else if (id instanceof String) {
            serializer.addIdAsString(id.toString());
        } else {
            serializer.addIdSerializedInJava(SerializationHelper.toByteArray(id));
        }
    }

    @Override
    public List<LuceneWork> toLuceneWorks(byte[] data) {
        try {
            Deserializer deserializer = this.provider.getDeserializer();
            LuceneWorkHydrator hydrator = new LuceneWorkHydrator(this.searchFactory);
            deserializer.deserialize(data, hydrator);
            return hydrator.getLuceneWorks();
        }
        catch (RuntimeException e) {
            if (e instanceof SearchException) {
                throw e;
            }
            throw log.unableToReadSerializedLuceneWorks(e);
        }
    }

    private void buildDocument(Document document, Serializer serializer) {
        List docFields = document.getFields();
        serializer.fields(docFields);
        for (Fieldable fieldable : docFields) {
            NumericField safeField;
            if (fieldable instanceof NumericField) {
                safeField = (NumericField)fieldable;
                LuceneNumericFieldContext context = new LuceneNumericFieldContext((NumericField)fieldable);
                switch (safeField.getDataType()) {
                    case INT: {
                        serializer.addIntNumericField(safeField.getNumericValue().intValue(), context);
                        break;
                    }
                    case LONG: {
                        serializer.addLongNumericField(safeField.getNumericValue().longValue(), context);
                        break;
                    }
                    case FLOAT: {
                        serializer.addFloatNumericField(safeField.getNumericValue().floatValue(), context);
                        break;
                    }
                    case DOUBLE: {
                        serializer.addDoubleNumericField(safeField.getNumericValue().doubleValue(), context);
                        break;
                    }
                    default: {
                        String dataType = safeField.getDataType() == null ? "null" : safeField.getDataType().toString();
                        throw log.unknownNumericFieldType(dataType);
                    }
                }
                continue;
            }
            if (fieldable instanceof Field) {
                safeField = (Field)fieldable;
                if (safeField.isBinary()) {
                    serializer.addFieldWithBinaryData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                if (safeField.stringValue() != null) {
                    serializer.addFieldWithStringData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                if (safeField.readerValue() != null && safeField.readerValue() instanceof Serializable) {
                    serializer.addFieldWithSerializableReaderData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                if (safeField.readerValue() != null) {
                    throw log.conversionFromReaderToStringNotYetImplemented();
                }
                if (safeField.tokenStreamValue() != null) {
                    serializer.addFieldWithTokenStreamData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                throw log.unknownFieldType(safeField.getClass());
            }
            if (fieldable != null) {
                serializer.addFieldWithSerializableFieldable(SerializationHelper.toByteArray((Serializable)fieldable));
                continue;
            }
            throw log.cannotSerializeCustomField(fieldable.getClass());
        }
        serializer.addDocument(document.getBoost());
    }

    @Override
    public String describeSerializer() {
        return this.provider.toString();
    }
}

