/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.naming.jndi;

import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.naming.jndi.CNCtx;
import org.jboss.as.jacorb.naming.jndi.CNNameParser;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public final class ExceptionMapper {
    private static final boolean debug = false;

    private ExceptionMapper() {
    }

    public static NamingException mapException(Exception e, CNCtx ctx, NameComponent[] inputName) throws NamingException {
        NamingException ne;
        if (e instanceof NamingException) {
            return (NamingException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof NotFound) {
            if (ctx.federation) {
                return ExceptionMapper.tryFed((NotFound)((Object)e), ctx, inputName);
            }
            ne = new NameNotFoundException();
        } else if (e instanceof CannotProceed) {
            ne = new CannotProceedException();
            NamingContext nc = ((CannotProceed)e).cxt;
            NameComponent[] rest = ((CannotProceed)e).rest_of_name;
            if (inputName != null && inputName.length > rest.length) {
                NameComponent[] resolvedName = new NameComponent[inputName.length - rest.length];
                System.arraycopy(inputName, 0, resolvedName, 0, resolvedName.length);
                ne.setResolvedObj(new CNCtx(ctx._orb, nc, ctx._env, ctx.makeFullName(resolvedName)));
            } else {
                ne.setResolvedObj(ctx);
            }
            ne.setRemainingName(CNNameParser.cosNameToName(rest));
        } else {
            ne = e instanceof InvalidName ? new InvalidNameException() : (e instanceof AlreadyBound ? new NameAlreadyBoundException() : (e instanceof NotEmpty ? new ContextNotEmptyException() : new NamingException()));
        }
        ne.setRootCause(e);
        return ne;
    }

    private static NamingException tryFed(NotFound e, CNCtx ctx, NameComponent[] inputName) throws NamingException {
        Object resolvedObj2;
        CNCtx resolvedObj;
        NameComponent[] rest = e.rest_of_name;
        if (rest.length == 1 && inputName != null) {
            NameComponent lastIn = inputName[inputName.length - 1];
            if (!rest[0].id.equals(lastIn.id) || rest[0].kind == null || !rest[0].kind.equals(lastIn.kind)) {
                NameNotFoundException ne = new NameNotFoundException();
                ne.setRemainingName(CNNameParser.cosNameToName(rest));
                ne.setRootCause(e);
                throw ne;
            }
        }
        NameComponent[] resolvedName = null;
        int len = 0;
        if (inputName != null && inputName.length >= rest.length) {
            if (e.why == NotFoundReason.not_context) {
                len = inputName.length - (rest.length - 1);
                if (rest.length == 1) {
                    rest = null;
                } else {
                    NameComponent[] tmp = new NameComponent[rest.length - 1];
                    System.arraycopy(rest, 1, tmp, 0, tmp.length);
                    rest = tmp;
                }
            } else {
                len = inputName.length - rest.length;
            }
            if (len > 0) {
                resolvedName = new NameComponent[len];
                System.arraycopy(inputName, 0, resolvedName, 0, len);
            }
        }
        CannotProceedException cpe = new CannotProceedException();
        cpe.setRootCause(e);
        if (rest != null && rest.length > 0) {
            cpe.setRemainingName(CNNameParser.cosNameToName(rest));
        }
        cpe.setEnvironment(ctx._env);
        CNCtx cNCtx = resolvedObj = resolvedName != null ? ctx.callResolve(resolvedName) : ctx;
        if (resolvedObj instanceof Context) {
            RefAddr addr = new RefAddr("nns"){
                private static final long serialVersionUID = 669984699392133792L;

                @Override
                public Object getContent() {
                    return resolvedObj;
                }
            };
            Reference ref = new Reference("java.lang.Object", addr);
            CompositeName cname = new CompositeName();
            cname.add("");
            cpe.setResolvedObj(ref);
            cpe.setAltName(cname);
            cpe.setAltNameCtx(resolvedObj);
            return cpe;
        }
        Name cname = CNNameParser.cosNameToName(resolvedName);
        try {
            resolvedObj2 = NamingManager.getObjectInstance(resolvedObj, cname, ctx, ctx._env);
        }
        catch (NamingException ge) {
            throw ge;
        }
        catch (Exception ge) {
            NamingException ne = JacORBMessages.MESSAGES.errorGeneratingObjectViaFactory();
            ne.setRootCause(ge);
            throw ne;
        }
        if (resolvedObj2 instanceof Context) {
            cpe.setResolvedObj(resolvedObj2);
        } else {
            cname.add("");
            cpe.setAltName(cname);
            final Object rf2 = resolvedObj2;
            RefAddr addr = new RefAddr("nns"){
                private static final long serialVersionUID = -785132553978269772L;

                @Override
                public Object getContent() {
                    return rf2;
                }
            };
            Reference ref = new Reference("java.lang.Object", addr);
            cpe.setResolvedObj(ref);
            cpe.setAltNameCtx(ctx);
        }
        return cpe;
    }
}

