/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcher;

public class LdapGroupSearcherFactory {
    private static final int searchTimeLimit = 10000;

    static LdapSearcher<LdapEntry[], LdapEntry> createForGroupToPrincipal(String baseDn, String groupDnAttribute, String groupNameAttribute, String principalAttribute, boolean recursive, BaseLdapGroupSearchResource.GroupName searchBy) {
        return new GroupToPrincipalSearcher(baseDn, groupDnAttribute, groupNameAttribute, principalAttribute, recursive, searchBy);
    }

    static LdapSearcher<LdapEntry[], LdapEntry> createForPrincipalToGroup(String groupAttribute, String groupNameAttribute) {
        return new PrincipalToGroupSearcher(groupAttribute, groupNameAttribute);
    }

    private static SearchControls createSearchControl(boolean recursive, String[] attributes) {
        if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
            DomainManagementLogger.SECURITY_LOGGER.tracef("createSearchControl recursive=%b,  attributes=%s", recursive, Arrays.toString(attributes));
        }
        SearchControls searchControls = new SearchControls();
        if (recursive) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        searchControls.setReturningAttributes(attributes);
        searchControls.setTimeLimit(10000);
        return searchControls;
    }

    private static String[] createArray(String ... elements) {
        ArrayList<String> elementList = new ArrayList<String>(elements.length);
        for (String current : elements) {
            if (current == null) continue;
            elementList.add(current);
        }
        return elementList.toArray(new String[elementList.size()]);
    }

    private static class PrincipalToGroupSearcher
    implements LdapSearcher<LdapEntry[], LdapEntry> {
        private final String groupAttribute;
        private final String groupNameAttribute;

        private PrincipalToGroupSearcher(String groupAttribute, String groupNameAttribute) {
            this.groupAttribute = groupAttribute;
            this.groupNameAttribute = groupNameAttribute;
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("PrincipalToGroupSearcher groupAttribute=%s", groupAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("PrincipalToGroupSearcher groupNameAttribute=%s", groupNameAttribute);
            }
        }

        @Override
        public LdapEntry[] search(DirContext dirContext, LdapEntry entry) throws IOException, NamingException {
            HashSet<LdapEntry> foundEntries = new HashSet<LdapEntry>();
            Attributes groups = dirContext.getAttributes(entry.getDistinguishedName(), new String[]{this.groupAttribute});
            Attribute groupRef = groups.get(this.groupAttribute);
            if (groupRef != null && groupRef.size() > 0) {
                NamingEnumeration<?> groupRefValues = groupRef.getAll();
                while (groupRefValues.hasMore()) {
                    String distingushedName = (String)groupRefValues.next();
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Group found with distinguishedName=%s", distingushedName);
                    String simpleName = null;
                    if (this.groupNameAttribute != null) {
                        Attributes groupNameAttrs = dirContext.getAttributes(distingushedName, new String[]{this.groupNameAttribute});
                        Attribute groupNameAttr = groupNameAttrs.get(this.groupNameAttribute);
                        simpleName = (String)groupNameAttr.get();
                        DomainManagementLogger.SECURITY_LOGGER.tracef("simpleName %s loaded for group with distinguishedName=%s", simpleName, distingushedName);
                    } else {
                        DomainManagementLogger.SECURITY_LOGGER.trace("No groupNameAttribute to load simpleName");
                    }
                    foundEntries.add(new LdapEntry(simpleName, distingushedName));
                }
            } else {
                DomainManagementLogger.SECURITY_LOGGER.tracef("No groups found for %s", entry);
            }
            return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
        }
    }

    private static class GroupToPrincipalSearcher
    implements LdapSearcher<LdapEntry[], LdapEntry> {
        private final String baseDn;
        private final String groupDnAttribute;
        private final String groupNameAttribute;
        private final String[] attributeArray;
        private final String filterString;
        private final boolean recursive;
        private final BaseLdapGroupSearchResource.GroupName searchBy;

        private GroupToPrincipalSearcher(String baseDn, String groupDnAttribute, String groupNameAttribute, String principalAttribute, boolean recursive, BaseLdapGroupSearchResource.GroupName searchBy) {
            this.baseDn = baseDn;
            this.groupDnAttribute = groupDnAttribute;
            this.groupNameAttribute = groupNameAttribute;
            this.attributeArray = LdapGroupSearcherFactory.createArray(new String[]{groupDnAttribute, groupNameAttribute});
            this.filterString = String.format("(%s={0})", principalAttribute);
            this.recursive = recursive;
            this.searchBy = searchBy;
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher baseDn=%s", baseDn);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher groupDnAttribute=%s", groupDnAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher groupNameAttribute=%s", groupNameAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher attributeArray=%s", Arrays.toString(this.attributeArray));
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher filterString=%s", this.filterString);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher recursive=%b", recursive);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher searchBy=%s", (Object)searchBy);
            }
        }

        @Override
        public LdapEntry[] search(DirContext dirContext, LdapEntry entry) throws IOException, NamingException {
            SearchControls searchControls = LdapGroupSearcherFactory.createSearchControl(this.recursive, this.attributeArray);
            HashSet<LdapEntry> foundEntries = new HashSet<LdapEntry>();
            Object[] searchParameter = this.getSearchParameter(entry);
            boolean trace = DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled();
            if (trace) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Performing search baseDn=%s, filterString=%s, searchParameter=%s", this.baseDn, this.filterString, Arrays.toString(searchParameter));
            }
            NamingEnumeration<SearchResult> searchResults = dirContext.search(this.baseDn, this.filterString, searchParameter, searchControls);
            if (trace && !searchResults.hasMore()) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No search results found.");
            }
            while (searchResults.hasMore()) {
                SearchResult current = searchResults.next();
                Attributes attributes = current.getAttributes();
                if (attributes != null) {
                    LdapEntry newEntry = this.convertToLdapEntry(current, attributes);
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Adding %s", newEntry);
                    foundEntries.add(newEntry);
                    continue;
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("No attributes found for %s", current);
            }
            return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
        }

        private LdapEntry convertToLdapEntry(SearchResult searchResult, Attributes attributes) throws NamingException {
            String simpleName = null;
            String distinguishedName = null;
            if (this.groupNameAttribute != null) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Getting groupNameAttribute=%s", this.groupNameAttribute);
                Attribute groupNameAttr = attributes.get(this.groupNameAttribute);
                if (groupNameAttr != null) {
                    simpleName = (String)groupNameAttr.get();
                }
            }
            if (this.groupDnAttribute != null) {
                if ("dn".equals(this.groupDnAttribute)) {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Obtaining dn using getNameInNamespace()");
                    distinguishedName = searchResult.getNameInNamespace();
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Getting groupDnAttribute=%s", this.groupDnAttribute);
                    Attribute groupDnAttr = attributes.get(this.groupDnAttribute);
                    if (groupDnAttr != null) {
                        distinguishedName = (String)groupDnAttr.get();
                    }
                }
            }
            return new LdapEntry(simpleName, distinguishedName);
        }

        private Object[] getSearchParameter(LdapEntry entry) {
            switch (this.searchBy) {
                case SIMPLE: {
                    return new String[]{entry.getSimpleName()};
                }
            }
            return new String[]{entry.getDistinguishedName()};
        }
    }
}

