/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.MethodLookupAction;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.annotated.ForwardingAnnotatedMethod;
import org.jboss.weld.util.reflection.Reflections;

public class InvokableAnnotatedMethod<T>
extends ForwardingAnnotatedMethod<T> {
    private final AnnotatedMethod<T> annotatedMethod;
    private volatile Map<Class<?>, Method> methods;

    public static <T> InvokableAnnotatedMethod<T> of(AnnotatedMethod<T> delegate) {
        return new InvokableAnnotatedMethod<T>(delegate);
    }

    public InvokableAnnotatedMethod(AnnotatedMethod<T> annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
        this.methods = Collections.singletonMap(annotatedMethod.getJavaMember().getDeclaringClass(), annotatedMethod.getJavaMember());
        AccessController.doPrivileged(SetAccessibleAction.of(annotatedMethod.getJavaMember()));
    }

    public <X> X invoke(Object instance, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (X)Reflections.cast(this.annotatedMethod.getJavaMember().invoke(instance, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X invokeOnInstance(Object instance, Object ... parameters) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map<Class<?>, Method> methods = this.methods;
        Method method = methods.get(instance.getClass());
        if (method == null) {
            Method delegate = this.annotatedMethod.getJavaMember();
            try {
                method = AccessController.doPrivileged(new MethodLookupAction(instance.getClass(), delegate.getName(), delegate.getParameterTypes()));
                AccessController.doPrivileged(SetAccessibleAction.of(method));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
            InvokableAnnotatedMethod invokableAnnotatedMethod = this;
            synchronized (invokableAnnotatedMethod) {
                HashMap newMethods = new HashMap(methods);
                newMethods.put(instance.getClass(), method);
                this.methods = Collections.unmodifiableMap(newMethods);
            }
        }
        return (X)Reflections.cast(method.invoke(instance, parameters));
    }

    @Override
    public AnnotatedMethod<T> delegate() {
        return this.annotatedMethod;
    }
}

