/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Properties;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.AbstractChannelFactory;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.slf4j.Logger;

public class NotifyServer {
    private static Configuration configuration = null;
    private static Logger logger = null;
    private static String fileName = null;
    private static String fileNameTyped = null;
    private static Properties props = new Properties();

    public static void configure(Configuration myConfiguration) {
        configuration = myConfiguration;
        logger = configuration.getLogger("jacorb.notify");
        fileName = configuration.getAttribute("jacorb.notify.ior_filename", "./notify.ior");
        fileNameTyped = configuration.getAttribute("jacorb.notifyTyped.ior_filename", "./notify.ior");
    }

    public static AbstractChannelFactory newFactory(ORB orb, POA rootPOA) throws Exception {
        props.put("jacorb.notification.enable_typed_channel", "off");
        props.put("jacorb.notification.ior_file", fileName);
        props.put("jacorb.notification.start_channels", "1");
        return AbstractChannelFactory.newFactory(orb, null, props);
    }

    public static AbstractChannelFactory createInstance(ORB orb, POA rootPOA) throws Exception {
        AbstractChannelFactory factory = null;
        try {
            Configuration config = ((org.jacorb.orb.ORB)orb).getConfiguration();
            NotifyServer.configure(config);
            factory = NotifyServer.newFactory(orb, rootPOA);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return factory;
    }
}

