/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.internal.jta.JtaTransaction;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionFactory;

public class JtaTransactionFactory
implements TransactionFactory<JtaTransaction> {
    public static final String SHORT_NAME = "jta";

    @Override
    public JtaTransaction createTransaction(TransactionCoordinator transactionCoordinator) {
        return new JtaTransaction(transactionCoordinator);
    }

    @Override
    public boolean canBeDriver() {
        return true;
    }

    @Override
    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    @Override
    public boolean compatibleWithJtaSynchronization() {
        return true;
    }

    @Override
    public boolean isJoinableJtaTransaction(TransactionCoordinator transactionCoordinator, JtaTransaction transaction) {
        try {
            UserTransaction ut;
            if (transaction != null && (ut = transaction.getUserTransaction()) != null) {
                return JtaStatusHelper.isActive(ut);
            }
            JtaPlatform jtaPlatform = transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform();
            if (jtaPlatform == null) {
                throw new TransactionException("Unable to check transaction status");
            }
            if (jtaPlatform.retrieveTransactionManager() != null) {
                return JtaStatusHelper.isActive(jtaPlatform.retrieveTransactionManager().getStatus());
            }
            UserTransaction ut2 = jtaPlatform.retrieveUserTransaction();
            return ut2 != null && JtaStatusHelper.isActive(ut2);
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", se);
        }
    }
}

