/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.build.internal.spaces;

import org.hibernate.loader.plan.build.internal.spaces.AbstractQuerySpace;
import org.hibernate.loader.plan.build.spi.ExpandingCollectionQuerySpace;
import org.hibernate.loader.plan.build.spi.ExpandingQuerySpaces;
import org.hibernate.loader.plan.spi.Join;
import org.hibernate.loader.plan.spi.QuerySpace;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.PropertyMapping;

public class CollectionQuerySpaceImpl
extends AbstractQuerySpace
implements ExpandingCollectionQuerySpace {
    private final CollectionPersister persister;

    public CollectionQuerySpaceImpl(CollectionPersister persister, String uid, ExpandingQuerySpaces querySpaces, boolean canJoinsBeRequired) {
        super(uid, QuerySpace.Disposition.COLLECTION, querySpaces, canJoinsBeRequired);
        this.persister = persister;
    }

    @Override
    public CollectionPersister getCollectionPersister() {
        return this.persister;
    }

    @Override
    public PropertyMapping getPropertyMapping() {
        return (PropertyMapping)((Object)this.persister);
    }

    @Override
    public String[] toAliasedColumns(String alias, String propertyName) {
        QueryableCollection queryableCollection = (QueryableCollection)this.persister;
        if (propertyName.equals("elements")) {
            return queryableCollection.getElementColumnNames(alias);
        }
        if (propertyName.equals("indices")) {
            return queryableCollection.getIndexColumnNames(alias);
        }
        throw new IllegalArgumentException(String.format("Collection propertyName must be either %s or %s; instead it was %s.", "elements", "indices", propertyName));
    }

    @Override
    public void addJoin(Join join) {
        this.internalGetJoins().add(join);
    }

    @Override
    public ExpandingQuerySpaces getExpandingQuerySpaces() {
        return super.getExpandingQuerySpaces();
    }
}

