/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.Cache;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.CacheServiceProvider;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.Services;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.XAResourceRecoveryRegistry;

public abstract class CacheAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheAdd.class.getPackage().getName());
    private static final String DEFAULTS = "infinispan-defaults.xml";
    private static final String QUERY_MODULE = "org.infinispan.query";
    private static volatile Map<CacheMode, Configuration> defaults = null;
    final CacheMode mode;

    public static synchronized Configuration getDefaultConfiguration(CacheMode cacheMode) {
        if (defaults == null) {
            ConfigurationBuilderHolder holder = CacheAdd.load(DEFAULTS);
            Configuration defaultConfig = holder.getDefaultConfigurationBuilder().build();
            EnumMap<CacheMode, Configuration> map = new EnumMap<CacheMode, Configuration>(CacheMode.class);
            map.put(defaultConfig.clustering().cacheMode(), defaultConfig);
            for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
                Configuration config = builder.build();
                map.put(config.clustering().cacheMode(), config);
            }
            for (CacheMode mode : CacheMode.values()) {
                if (map.containsKey(mode)) continue;
                map.put(mode, new ConfigurationBuilder().read(defaultConfig).clustering().cacheMode(mode).build());
            }
            defaults = map;
        }
        return defaults.get(cacheMode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ConfigurationBuilderHolder load(String resource) {
        URL url = CacheAdd.find(resource, CacheAdd.class.getClassLoader());
        log.debugf("Loading Infinispan defaults from %s", (Object)url.toString());
        ParserRegistry parser = new ParserRegistry(ParserRegistry.class.getClassLoader());
        try (InputStream input = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = parser.parse(input);
            return configurationBuilderHolder;
        }
        catch (IOException e) {
            throw InfinispanMessages.MESSAGES.failedToParse(e, url);
        }
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(String.format("Failed to locate %s", resource));
    }

    CacheAdd(CacheMode mode) {
        this.mode = mode;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode cacheModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        newControllers.addAll(this.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CacheResourceDefinition.JNDI_NAME.resolveModelAttribute(context, cacheModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CacheResourceDefinition.START.resolveModelAttribute(context, cacheModel).asString()).getMode();
        resolvedValue = CacheResourceDefinition.MODULE.resolveModelAttribute(context, cacheModel);
        String module = resolvedValue.isDefined() ? resolvedValue.asString() : (Indexing.valueOf(CacheResourceDefinition.INDEXING.resolveModelAttribute(context, cacheModel).asString()).isEnabled() ? QUERY_MODULE : null);
        ModuleIdentifier moduleId = module != null ? ModuleIdentifier.fromString((String)module) : null;
        LinkedList dependencies = new LinkedList();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(CacheAdd.getDefaultConfiguration(this.mode));
        CacheConfigurationDependencies cacheConfigurationDependencies = new CacheConfigurationDependencies();
        CacheDependencies cacheDependencies = new CacheDependencies();
        this.processModelNode(context, containerName, cacheModel, builder, cacheConfigurationDependencies, cacheDependencies, dependencies);
        String defaultCacheName = CacheContainerResourceDefinition.DEFAULT_CACHE.resolveModelAttribute(context, containerModel).asString();
        boolean defaultCache = cacheName.equals(defaultCacheName);
        ServiceTarget target = context.getServiceTarget();
        ArrayList controllers = new ArrayList(3);
        controllers.add(this.installCacheConfigurationService(target, containerName, cacheName, defaultCache, moduleId, builder, cacheConfigurationDependencies, dependencies, verificationHandler));
        log.debugf("Cache configuration service for %s installed for container %s", (Object)cacheName, (Object)containerName);
        controllers.add(this.installCacheService(target, containerName, cacheName, defaultCache, initialMode, cacheDependencies, verificationHandler));
        controllers.add(this.installJndiService(target, containerName, cacheName, defaultCache, jndiName, verificationHandler));
        log.debugf("Cache service for cache %s installed for container %s", (Object)cacheName, (Object)containerName);
        if (this.mode.isClustered()) {
            for (CacheServiceProvider provider : ServiceLoader.load(CacheServiceProvider.class, CacheServiceProvider.class.getClassLoader())) {
                log.debugf("Installing %s for cache %s/%s", (Object)provider.getClass().getSimpleName(), (Object)containerName, (Object)cacheName);
                controllers.addAll(provider.install(target, containerName, cacheName, defaultCache, moduleId));
            }
        }
        return controllers;
    }

    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CacheResourceDefinition.JNDI_NAME.resolveModelAttribute(context, cacheModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        String defaultCacheName = CacheContainerResourceDefinition.DEFAULT_CACHE.resolveModelAttribute(context, containerModel).asString();
        boolean defaultCache = cacheName.equals(defaultCacheName);
        ContextNames.BindInfo binding = CacheAdd.createCacheBinding(jndiName != null ? JndiNameFactory.parse((String)jndiName) : CacheAdd.createJndiName(containerName, cacheName));
        context.removeService(binding.getBinderServiceName());
        context.removeService(CacheService.getServiceName(containerName, cacheName));
        context.removeService(CacheConfigurationService.getServiceName(containerName, cacheName));
        for (CacheServiceProvider provider : ServiceLoader.load(CacheServiceProvider.class, CacheServiceProvider.class.getClassLoader())) {
            for (ServiceName name : provider.getServiceNames(containerName, cacheName, defaultCache)) {
                context.removeService(name);
            }
        }
        log.debugf("cache %s removed for container %s", (Object)cacheName, (Object)containerName);
    }

    protected PathAddress getCacheAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    protected PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        return containerAddress;
    }

    ServiceController<?> installCacheConfigurationService(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, ModuleIdentifier moduleId, ConfigurationBuilder builder, CacheConfigurationDependencies cacheConfigurationDependencies, List<Dependency<?>> dependencies, ServiceVerificationHandler verificationHandler) {
        CacheConfigurationService service = new CacheConfigurationService(cacheName, builder, moduleId, cacheConfigurationDependencies);
        ServiceBuilder configBuilder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)CacheConfigurationService.getServiceName(containerName, cacheName), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, cacheConfigurationDependencies.getCacheContainerInjector()).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, cacheConfigurationDependencies.getModuleLoaderInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        for (Dependency<?> dependency : dependencies) {
            CacheAdd.addDependency(configBuilder, dependency);
        }
        if (defaultCache) {
            configBuilder.addAliases(new ServiceName[]{CacheConfigurationService.getServiceName(containerName, null)});
        }
        return configBuilder.install();
    }

    ServiceController<?> installCacheService(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, ServiceController.Mode initialMode, CacheDependencies cacheDependencies, ServiceVerificationHandler verificationHandler) {
        CacheService service = new CacheService(cacheName, cacheDependencies);
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)CacheService.getServiceName(containerName, cacheName), service).addDependency(GlobalComponentRegistryService.getServiceName(containerName)).addDependency(CacheConfigurationService.getServiceName(containerName, cacheName)).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, cacheDependencies.getCacheContainerInjector()).setInitialMode(initialMode);
        if (defaultCache) {
            builder.addAliases(new ServiceName[]{CacheService.getServiceName(containerName, null)});
        }
        if (initialMode == ServiceController.Mode.ACTIVE) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, String jndiName, ServiceVerificationHandler verificationHandler) {
        ServiceName cacheServiceName = CacheService.getServiceName(containerName, cacheName);
        ContextNames.BindInfo binding = CacheAdd.createCacheBinding(jndiName != null ? JndiNameFactory.parse((String)jndiName) : CacheAdd.createJndiName(containerName, cacheName));
        BinderService binder = new BinderService(binding.getBindName());
        ServiceBuilder builder = target.addService(binding.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{binding.getBindName()})}).addDependency(cacheServiceName, Cache.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(binding.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        if (defaultCache) {
            ContextNames.BindInfo defaultBinding = CacheAdd.createCacheBinding(CacheAdd.createJndiName(containerName, "default"));
            builder.addAliases(new ServiceName[]{defaultBinding.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{defaultBinding.getBindName()})});
        }
        return builder.install();
    }

    private static JndiName createJndiName(String container, String cache) {
        return JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"infinispan", "cache", container, cache});
    }

    private static ContextNames.BindInfo createCacheBinding(JndiName name) {
        return ContextNames.bindInfoFor((String)name.getAbsoluteName());
    }

    private static <T> void addDependency(ServiceBuilder<?> builder, Dependency<T> dependency) {
        ServiceName name = dependency.getName();
        Injector<T> injector = dependency.getInjector();
        if (injector != null) {
            builder.addDependency(name, dependency.getType(), injector);
        } else {
            builder.addDependency(name);
        }
    }

    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        CacheResourceDefinition.START.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.BATCHING.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.INDEXING.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.JNDI_NAME.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.MODULE.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.INDEXING_PROPERTIES.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.STATISTICS_ENABLED.validateAndSet(fromModel, toModel);
    }

    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, CacheConfigurationDependencies cacheConfigurationDependencies, CacheDependencies cacheDependencies, List<Dependency<?>> dependencies) throws OperationFailedException {
        String storeKey;
        builder.jmxStatistics().enabled(CacheResourceDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, cache).asBoolean());
        Indexing indexing = Indexing.valueOf(CacheResourceDefinition.INDEXING.resolveModelAttribute(context, cache).asString());
        boolean batching = CacheResourceDefinition.BATCHING.resolveModelAttribute(context, cache).asBoolean();
        builder.clustering().cacheMode(this.mode);
        ModelNode indexingPropertiesModel = CacheResourceDefinition.INDEXING_PROPERTIES.resolveModelAttribute(context, cache);
        Properties indexingProperties = new Properties();
        if (indexing.isEnabled() && indexingPropertiesModel.isDefined()) {
            for (Property p : indexingPropertiesModel.asPropertyList()) {
                String value = p.getValue().asString();
                indexingProperties.put(p.getName(), value);
            }
        }
        builder.indexing().enabled(indexing.isEnabled()).indexLocalOnly(indexing.isLocalOnly()).withProperties(indexingProperties);
        IsolationLevel isolationLevel = CacheAdd.getDefaultConfiguration(this.mode).locking().isolationLevel();
        if (cache.hasDefined("locking") && cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
            ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
            isolationLevel = IsolationLevel.valueOf((String)LockingResourceDefinition.ISOLATION.resolveModelAttribute(context, locking).asString());
            boolean striping = LockingResourceDefinition.STRIPING.resolveModelAttribute(context, locking).asBoolean();
            long acquireTimeout = LockingResourceDefinition.ACQUIRE_TIMEOUT.resolveModelAttribute(context, locking).asLong();
            int concurrencyLevel = LockingResourceDefinition.CONCURRENCY_LEVEL.resolveModelAttribute(context, locking).asInt();
            builder.locking().isolationLevel(isolationLevel).useLockStriping(striping).lockAcquisitionTimeout(acquireTimeout).concurrencyLevel(concurrencyLevel);
        }
        LockingMode lockingMode = CacheAdd.getDefaultConfiguration(this.mode).transaction().lockingMode();
        if (cache.hasDefined("transaction") && cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
            long stopTimeout = TransactionResourceDefinition.STOP_TIMEOUT.resolveModelAttribute(context, transaction).asLong();
            TransactionMode txMode = TransactionMode.valueOf(TransactionResourceDefinition.MODE.resolveModelAttribute(context, transaction).asString());
            lockingMode = LockingMode.valueOf((String)TransactionResourceDefinition.LOCKING.resolveModelAttribute(context, transaction).asString());
            builder.transaction().cacheStopTimeout(stopTimeout).transactionMode(txMode.getMode()).lockingMode(lockingMode).useSynchronization(!txMode.isXAEnabled()).recovery().enabled(txMode.isRecoveryEnabled());
            if (txMode.getMode().isTransactional()) {
                dependencies.add(new Dependency<TransactionManager>(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, cacheConfigurationDependencies.getTransactionManagerInjector()));
                if (!txMode.isXAEnabled()) {
                    dependencies.add(new Dependency<TransactionSynchronizationRegistry>(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, cacheConfigurationDependencies.getTransactionSynchronizationRegistryInjector()));
                }
            }
            if (txMode.isRecoveryEnabled()) {
                dependencies.add(new Dependency<XAResourceRecoveryRegistry>(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, cacheDependencies.getRecoveryRegistryInjector()));
            }
        }
        if (lockingMode == LockingMode.OPTIMISTIC && isolationLevel == IsolationLevel.REPEATABLE_READ && this.mode.isSynchronous() && !this.mode.isInvalidation()) {
            builder.locking().writeSkewCheck(true);
            builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
        }
        if (batching) {
            builder.transaction().transactionMode(org.infinispan.transaction.TransactionMode.TRANSACTIONAL).invocationBatching().enable();
            cacheConfigurationDependencies.getTransactionManagerInjector().inject((Object)BatchModeTransactionManager.getInstance());
        } else {
            builder.transaction().invocationBatching().disable();
        }
        if (cache.hasDefined("eviction") && cache.get(new String[]{"eviction", "EVICTION"}).isDefined()) {
            ModelNode eviction = cache.get(new String[]{"eviction", "EVICTION"});
            EvictionStrategy strategy = EvictionStrategy.valueOf((String)EvictionResourceDefinition.STRATEGY.resolveModelAttribute(context, eviction).asString());
            builder.eviction().strategy(strategy);
            if (strategy.isEnabled()) {
                int maxEntries = EvictionResourceDefinition.MAX_ENTRIES.resolveModelAttribute(context, eviction).asInt();
                builder.eviction().maxEntries(maxEntries);
            }
        }
        if (cache.hasDefined("expiration") && cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
            long maxIdle = ExpirationResourceDefinition.MAX_IDLE.resolveModelAttribute(context, expiration).asLong();
            long lifespan = ExpirationResourceDefinition.LIFESPAN.resolveModelAttribute(context, expiration).asLong();
            long interval = ExpirationResourceDefinition.INTERVAL.resolveModelAttribute(context, expiration).asLong();
            builder.expiration().maxIdle(maxIdle).lifespan(lifespan).wakeUpInterval(interval);
            if (maxIdle > 0L || lifespan > 0L) {
                builder.expiration().enableReaper();
            } else {
                builder.expiration().disableReaper();
            }
        }
        if ((storeKey = CacheAdd.findStoreKey(cache)) != null) {
            ModelNode store = CacheAdd.getStoreModelNode(cache);
            boolean shared = StoreResourceDefinition.SHARED.resolveModelAttribute(context, store).asBoolean();
            boolean preload = StoreResourceDefinition.PRELOAD.resolveModelAttribute(context, store).asBoolean();
            boolean passivation = StoreResourceDefinition.PASSIVATION.resolveModelAttribute(context, store).asBoolean();
            boolean fetchState = StoreResourceDefinition.FETCH_STATE.resolveModelAttribute(context, store).asBoolean();
            boolean purge = StoreResourceDefinition.PURGE.resolveModelAttribute(context, store).asBoolean();
            boolean singleton = StoreResourceDefinition.SINGLETON.resolveModelAttribute(context, store).asBoolean();
            boolean async = store.hasDefined("write-behind") && store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined();
            PersistenceConfigurationBuilder persistenceBuilder = builder.persistence().passivation(passivation);
            StoreConfigurationBuilder storeBuilder = (StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)this.buildCacheStore(context, persistenceBuilder, containerName, store, storeKey, dependencies).fetchPersistentState(fetchState)).preload(preload)).shared(shared)).purgeOnStartup(purge);
            storeBuilder.singleton().enabled(singleton);
            if (async) {
                ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
                storeBuilder.async().enable().flushLockTimeout(StoreWriteBehindResourceDefinition.FLUSH_LOCK_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).modificationQueueSize(StoreWriteBehindResourceDefinition.MODIFICATION_QUEUE_SIZE.resolveModelAttribute(context, writeBehind).asInt()).shutdownTimeout(StoreWriteBehindResourceDefinition.SHUTDOWN_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).threadPoolSize(StoreWriteBehindResourceDefinition.THREAD_POOL_SIZE.resolveModelAttribute(context, writeBehind).asInt());
            }
            TypedProperties properties = new TypedProperties();
            if (store.hasDefined("property")) {
                for (Property property : store.get("property").asPropertyList()) {
                    String propertyName = property.getName();
                    ModelNode propertyValue = null;
                    propertyValue = StorePropertyResourceDefinition.VALUE.resolveModelAttribute(context, property.getValue());
                    properties.setProperty(propertyName, propertyValue.asString());
                }
            }
            storeBuilder.withProperties((Properties)properties);
        }
    }

    private static String findStoreKey(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return "store";
        }
        if (cache.hasDefined("file-store")) {
            return "file-store";
        }
        if (cache.hasDefined("string-keyed-jdbc-store")) {
            return "string-keyed-jdbc-store";
        }
        if (cache.hasDefined("binary-keyed-jdbc-store")) {
            return "binary-keyed-jdbc-store";
        }
        if (cache.hasDefined("mixed-keyed-jdbc-store")) {
            return "mixed-keyed-jdbc-store";
        }
        if (cache.hasDefined("remote-store")) {
            return "remote-store";
        }
        return null;
    }

    private static ModelNode getStoreModelNode(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return cache.get(new String[]{"store", "STORE"});
        }
        if (cache.hasDefined("file-store")) {
            return cache.get(new String[]{"file-store", "FILE_STORE"});
        }
        if (cache.hasDefined("string-keyed-jdbc-store")) {
            return cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("binary-keyed-jdbc-store")) {
            return cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("mixed-keyed-jdbc-store")) {
            return cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("remote-store")) {
            return cache.get(new String[]{"remote-store", "REMOTE_STORE"});
        }
        return null;
    }

    private StoreConfigurationBuilder<?, ?> buildCacheStore(OperationContext context, PersistenceConfigurationBuilder persistenceBuilder, String containerName, ModelNode store, String storeKey, List<Dependency<?>> dependencies) throws OperationFailedException {
        ModelNode resolvedValue = null;
        if (storeKey.equals("file-store")) {
            final SingleFileStoreConfigurationBuilder builder = persistenceBuilder.addSingleFileStore();
            resolvedValue = FileStoreResourceDefinition.PATH.resolveModelAttribute(context, store);
            final String path = resolvedValue.isDefined() ? resolvedValue.asString() : "infinispan" + File.separatorChar + containerName;
            resolvedValue = FileStoreResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, store);
            final String relativeTo = resolvedValue.isDefined() ? resolvedValue.asString() : "jboss.server.data.dir";
            Injector<PathManager> injector = new Injector<PathManager>(){
                private volatile PathManager.Callback.Handle callbackHandle;

                public void inject(PathManager value) {
                    this.callbackHandle = value.registerCallback(relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                    builder.location(value.resolveRelativePathEntry(path, relativeTo));
                }

                public void uninject() {
                    if (this.callbackHandle != null) {
                        this.callbackHandle.remove();
                    }
                }
            };
            dependencies.add(new Dependency<PathManager>(PathManagerService.SERVICE_NAME, PathManager.class, injector));
            return builder;
        }
        if (storeKey.equals("string-keyed-jdbc-store") || storeKey.equals("binary-keyed-jdbc-store") || storeKey.equals("mixed-keyed-jdbc-store")) {
            ModelNode dialect = JDBCStoreResourceDefinition.DIALECT.resolveModelAttribute(context, store);
            DatabaseType type = dialect.isDefined() ? DatabaseType.valueOf((String)dialect.asString()) : null;
            AbstractJdbcStoreConfigurationBuilder<?, ?> builder = CacheAdd.buildJdbcStore(persistenceBuilder, context, store, type);
            String datasource = JDBCStoreResourceDefinition.DATA_SOURCE.resolveModelAttribute(context, store).asString();
            dependencies.add(new Dependency(ServiceName.JBOSS.append(new String[]{"data-source", datasource})));
            builder.dataSource().jndiUrl(datasource);
            return builder;
        }
        if (storeKey.equals("remote-store")) {
            final RemoteStoreConfigurationBuilder builder = (RemoteStoreConfigurationBuilder)persistenceBuilder.addStore(RemoteStoreConfigurationBuilder.class);
            for (ModelNode server : store.require("remote-servers").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                Injector<OutboundSocketBinding> injector = new Injector<OutboundSocketBinding>(){

                    public void inject(OutboundSocketBinding value) {
                        try {
                            builder.addServer().host(value.getDestinationAddress().getHostAddress()).port(value.getDestinationPort());
                        }
                        catch (UnknownHostException e) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(e, value);
                        }
                    }

                    public void uninject() {
                    }
                };
                dependencies.add(new Dependency<OutboundSocketBinding>(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, injector));
            }
            if (store.hasDefined("cache")) {
                builder.remoteCacheName(store.get("cache").asString());
            }
            if (store.hasDefined("socket-timeout")) {
                builder.socketTimeout(store.require("socket-timeout").asLong());
            }
            if (store.hasDefined("tcp-no-delay")) {
                builder.tcpNoDelay(store.require("tcp-no-delay").asBoolean());
            }
            return builder;
        }
        String className = store.require("class").asString();
        try {
            return persistenceBuilder.addStore(StoreConfigurationBuilder.class.getClassLoader().loadClass(className).asSubclass(StoreConfigurationBuilder.class));
        }
        catch (Exception e) {
            throw InfinispanMessages.MESSAGES.invalidCacheStore(e, className);
        }
    }

    private static AbstractJdbcStoreConfigurationBuilder<?, ?> buildJdbcStore(PersistenceConfigurationBuilder persistenceBuilder, OperationContext context, ModelNode store, DatabaseType type) throws OperationFailedException {
        boolean useStringKeyedTable = store.hasDefined("string-keyed-table");
        boolean useBinaryKeyedTable = store.hasDefined("binary-keyed-table");
        if (useStringKeyedTable && !useBinaryKeyedTable) {
            JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)persistenceBuilder.addStore(JdbcStringBasedStoreConfigurationBuilder.class);
            CacheAdd.buildStringKeyedTable(builder.table(), context, store.get("string-keyed-table"), type);
            return builder;
        }
        if (useBinaryKeyedTable && !useStringKeyedTable) {
            JdbcBinaryStoreConfigurationBuilder builder = (JdbcBinaryStoreConfigurationBuilder)persistenceBuilder.addStore(JdbcBinaryStoreConfigurationBuilder.class);
            CacheAdd.buildBinaryKeyedTable(builder.table(), context, store.get("binary-keyed-table"), type);
            return builder;
        }
        JdbcMixedStoreConfigurationBuilder builder = (JdbcMixedStoreConfigurationBuilder)persistenceBuilder.addStore(JdbcMixedStoreConfigurationBuilder.class);
        CacheAdd.buildStringKeyedTable(builder.stringTable(), context, store.get("string-keyed-table"), type);
        CacheAdd.buildBinaryKeyedTable(builder.binaryTable(), context, store.get("binary-keyed-table"), type);
        return builder;
    }

    private static void buildBinaryKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table, DatabaseType type) throws OperationFailedException {
        CacheAdd.buildTable(builder, context, table, type, "ispn_bucket");
    }

    private static void buildStringKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table, DatabaseType type) throws OperationFailedException {
        CacheAdd.buildTable(builder, context, table, type, "ispn_entry");
    }

    private static void buildTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table, DatabaseType type, String defaultTableNamePrefix) throws OperationFailedException {
        ModelNode tableNamePrefix = JDBCStoreResourceDefinition.PREFIX.resolveModelAttribute(context, table);
        builder.databaseType(type).batchSize(JDBCStoreResourceDefinition.BATCH_SIZE.resolveModelAttribute(context, table).asInt()).fetchSize(JDBCStoreResourceDefinition.FETCH_SIZE.resolveModelAttribute(context, table).asInt()).tableNamePrefix(tableNamePrefix.isDefined() ? tableNamePrefix.asString() : defaultTableNamePrefix).idColumnName(CacheAdd.getColumnProperty(context, table, "id-column", (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_NAME, "id")).idColumnType(CacheAdd.getColumnProperty(context, table, "id-column", (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_TYPE, "VARCHAR")).dataColumnName(CacheAdd.getColumnProperty(context, table, "data-column", (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_NAME, "datum")).dataColumnType(CacheAdd.getColumnProperty(context, table, "data-column", (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_TYPE, "BINARY")).timestampColumnName(CacheAdd.getColumnProperty(context, table, "timestamp-column", (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_NAME, "version")).timestampColumnType(CacheAdd.getColumnProperty(context, table, "timestamp-column", (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_TYPE, "BIGINT"));
    }

    private static String getColumnProperty(OperationContext context, ModelNode table, String columnKey, AttributeDefinition columnAttribute, String defaultValue) throws OperationFailedException {
        if (!table.isDefined() || !table.hasDefined(columnKey)) {
            return defaultValue;
        }
        ModelNode column = table.get(columnKey);
        ModelNode resolvedValue = null;
        resolvedValue = columnAttribute.resolveModelAttribute(context, column);
        return resolvedValue.isDefined() ? resolvedValue.asString() : defaultValue;
    }

    static class CacheConfigurationDependencies
    implements CacheConfigurationService.Dependencies {
        private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
        private final InjectedValue<TransactionManager> tm = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> tsr = new InjectedValue();
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        CacheConfigurationDependencies() {
        }

        Injector<EmbeddedCacheManager> getCacheContainerInjector() {
            return this.container;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.tm;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.tsr;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public TransactionManager getTransactionManager() {
            return (TransactionManager)this.tm.getOptionalValue();
        }

        @Override
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return (TransactionSynchronizationRegistry)this.tsr.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }

    static class CacheDependencies
    implements CacheService.Dependencies {
        private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();

        CacheDependencies() {
        }

        Injector<EmbeddedCacheManager> getCacheContainerInjector() {
            return this.container;
        }

        Injector<XAResourceRecoveryRegistry> getRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public XAResourceRecoveryRegistry getRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }
    }

    protected class Dependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;

        Dependency(ServiceName name) {
            this(name, null, null);
        }

        Dependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
        }

        ServiceName getName() {
            return this.name;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getInjector() {
            return this.target;
        }
    }
}

