/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAdd;
import org.jboss.as.clustering.infinispan.subsystem.CacheRemove;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CacheContainerRemove
extends AbstractRemoveStepHandler {
    public static final CacheContainerRemove INSTANCE = new CacheContainerRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String containerName = address.getLastElement().getValue();
        CacheContainerRemove.removeExistingCacheServices(context, model, containerName);
        CacheContainerAdd.INSTANCE.removeRuntimeServices(context, operation, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String containerName = address.getLastElement().getValue();
        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
        CacheContainerAdd.INSTANCE.installRuntimeServices(context, operation, model, verificationHandler);
        CacheContainerRemove.reinstallExistingCacheServices(context, model, containerName, verificationHandler);
    }

    private static void reinstallExistingCacheServices(OperationContext context, ModelNode containerModel, String containerName, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        for (String cacheType : CacheRemove.INSTANCE.getCacheTypes()) {
            CacheAdd addHandler = CacheRemove.INSTANCE.getAddHandler(cacheType);
            List<Property> caches = CacheContainerRemove.getCachesFromParentModel(cacheType, containerModel);
            if (caches == null) continue;
            for (Property cache : caches) {
                String cacheName = cache.getName();
                ModelNode cacheModel = cache.getValue();
                ModelNode operation = CacheContainerRemove.createCacheAddOperation(cacheType, containerName, cacheName);
                addHandler.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler);
            }
        }
    }

    private static void removeExistingCacheServices(OperationContext context, ModelNode containerModel, String containerName) throws OperationFailedException {
        for (String cacheType : CacheRemove.INSTANCE.getCacheTypes()) {
            CacheAdd addHandler = CacheRemove.INSTANCE.getAddHandler(cacheType);
            List<Property> caches = CacheContainerRemove.getCachesFromParentModel(cacheType, containerModel);
            if (caches == null) continue;
            for (Property cache : caches) {
                String cacheName = cache.getName();
                ModelNode cacheModel = cache.getValue();
                ModelNode operation = CacheContainerRemove.createCacheRemoveOperation(cacheType, containerName, cacheName);
                addHandler.removeRuntimeServices(context, operation, containerModel, cacheModel);
            }
        }
    }

    private static List<Property> getCachesFromParentModel(String cacheType, ModelNode model) {
        List cacheList = null;
        ModelNode caches = model.get(cacheType);
        if (caches.isDefined() && caches.getType() == ModelType.OBJECT) {
            cacheList = caches.asPropertyList();
            return cacheList;
        }
        return null;
    }

    private static ModelNode createCacheRemoveOperation(String cacheType, String containerName, String cacheName) {
        PathAddress cacheAddr = CacheContainerRemove.getCacheAddress(containerName, cacheName, cacheType);
        ModelNode removeOp = new ModelNode();
        removeOp.get("operation").set("remove");
        removeOp.get("address").set(cacheAddr.toModelNode());
        return removeOp;
    }

    private static ModelNode createCacheAddOperation(String cacheType, String containerName, String cacheName) {
        PathAddress cacheAddr = CacheContainerRemove.getCacheAddress(containerName, cacheName, cacheType);
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(cacheAddr.toModelNode());
        return addOp;
    }

    private static PathAddress getCacheAddress(String containerName, String cacheName, String cacheType) {
        PathAddress cacheAddr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"infinispan"), PathElement.pathElement((String)"cache-container", (String)containerName), PathElement.pathElement((String)cacheType, (String)cacheName)});
        return cacheAddr;
    }
}

