/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WildFlyProviderResolver
implements ValidationProviderResolver {
    public List<ValidationProvider<?>> getValidationProviders() {
        List<ValidationProvider<?>> providers = this.loadProviders(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
        if (providers != null && !providers.isEmpty()) {
            return providers;
        }
        return this.loadProviders(WildFlySecurityManager.getClassLoaderPrivileged(WildFlyProviderResolver.class));
    }

    private List<ValidationProvider<?>> loadProviders(ClassLoader classLoader) {
        Iterator<ValidationProvider> providerIterator = ServiceLoader.load(ValidationProvider.class, classLoader).iterator();
        LinkedList providers = new LinkedList();
        while (providerIterator.hasNext()) {
            try {
                ValidationProvider provider = providerIterator.next();
                if (provider.getClass().getName().equals(HibernateValidator.class.getName())) {
                    providers.addFirst(provider);
                    continue;
                }
                providers.add(provider);
            }
            catch (ServiceConfigurationError e) {}
        }
        return providers;
    }
}

