/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SymmetricBindingBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public SymmetricBindingBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SYMMETRIC_BINDING, SP12Constants.SYMMETRIC_BINDING};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SymmetricBinding symmetricBinding = new SymmetricBinding(consts, this.builder);
        Policy policy = this.builder.getPolicy((Object)DOMUtils.getFirstElement((Node)element));
        Iterator iterator = (policy = policy.normalize(this.builder.getPolicyRegistry(), false)).getAlternatives();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("sp:SymmetricBinding must specify at least one alternative");
        }
        this.processAlternatives((List)iterator.next(), symmetricBinding, consts);
        return symmetricBinding;
    }

    private void processAlternatives(List<Assertion> assertions, SymmetricBinding symmetricBinding, SPConstants consts) {
        boolean foundAlgorithmSuite = false;
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (!consts.getNamespace().equals(name.getNamespaceURI()) && !SP12Constants.INSTANCE.getNamespace().equals(name.getNamespaceURI())) continue;
            if ("AlgorithmSuite".equals(name.getLocalPart())) {
                foundAlgorithmSuite = true;
                symmetricBinding.setAlgorithmSuite((AlgorithmSuite)assertion);
                continue;
            }
            if ("Layout".equals(name.getLocalPart())) {
                symmetricBinding.setLayout((Layout)assertion);
                continue;
            }
            if ("IncludeTimestamp".equals(name.getLocalPart())) {
                symmetricBinding.setIncludeTimestamp(true);
                continue;
            }
            if ("ProtectionToken".equals(name.getLocalPart())) {
                symmetricBinding.setProtectionToken((ProtectionToken)assertion);
                continue;
            }
            if ("EncryptBeforeSigning".equals(name.getLocalPart())) {
                symmetricBinding.setProtectionOrder(SPConstants.ProtectionOrder.EncryptBeforeSigning);
                continue;
            }
            if ("SignBeforeEncrypting".equals(name.getLocalPart())) {
                symmetricBinding.setProtectionOrder(SPConstants.ProtectionOrder.SignBeforeEncrypting);
                continue;
            }
            if ("OnlySignEntireHeadersAndBody".equals(name.getLocalPart())) {
                symmetricBinding.setEntireHeadersAndBodySignatures(true);
                continue;
            }
            if ("EncryptSignature".equals(name.getLocalPart())) {
                symmetricBinding.setSignatureProtection(true);
                continue;
            }
            if (!"ProtectTokens".equals(name.getLocalPart())) continue;
            symmetricBinding.setTokenProtection(true);
        }
        if (!foundAlgorithmSuite && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:SymmetricBinding/wsp:Policy/sp:AlgorithmSuite must have a value");
        }
    }
}

