/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Wss10;

public class Wss11
extends Wss10 {
    private boolean mustSupportRefThumbprint;
    private boolean mustSupportRefEncryptedKey;
    private boolean requireSignatureConfirmation;

    public Wss11(SPConstants version) {
        super(version);
    }

    public boolean isMustSupportRefEncryptedKey() {
        return this.mustSupportRefEncryptedKey;
    }

    public void setMustSupportRefEncryptedKey(boolean mustSupportRefEncryptedKey) {
        this.mustSupportRefEncryptedKey = mustSupportRefEncryptedKey;
    }

    public boolean isMustSupportRefThumbprint() {
        return this.mustSupportRefThumbprint;
    }

    public void setMustSupportRefThumbprint(boolean mustSupportRefThumbprint) {
        this.mustSupportRefThumbprint = mustSupportRefThumbprint;
    }

    public boolean isRequireSignatureConfirmation() {
        return this.requireSignatureConfirmation;
    }

    public void setRequireSignatureConfirmation(boolean requireSignatureConfirmation) {
        this.requireSignatureConfirmation = requireSignatureConfirmation;
    }

    @Override
    public QName getRealName() {
        return this.constants.getWSS11();
    }

    @Override
    public QName getName() {
        return SP12Constants.INSTANCE.getWSS11();
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.isMustSupportRefKeyIdentifier()) {
            writer.writeStartElement(prefix, "MustSupportRefKeyIdentifier", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefIssuerSerial()) {
            writer.writeStartElement(prefix, "MustSupportRefIssuerSerial", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefExternalURI()) {
            writer.writeStartElement(prefix, "MustSupportRefExternalURI", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEmbeddedToken()) {
            writer.writeStartElement(prefix, "MustSupportRefEmbeddedToken", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefThumbprint()) {
            writer.writeStartElement(prefix, "MustSupportRefThumbprint", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEncryptedKey()) {
            writer.writeStartElement(prefix, "MustSupportRefEncryptedKey", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireSignatureConfirmation()) {
            writer.writeStartElement(prefix, "RequireSignatureConfirmation", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

