/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.JBossLevelMapping;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class JBossLogManagerFacade {
    public static final String LOG4J_ROOT_NAME = "root";
    public static final String JBL_ROOT_NAME = "";
    private static final Logger.AttachmentKey<Logger> LOGGER_KEY = new Logger.AttachmentKey();
    private static final Logger.AttachmentKey<Hierarchy> HIERARCHY_KEY = new Logger.AttachmentKey();

    private JBossLogManagerFacade() {
    }

    static org.jboss.logmanager.Logger getJBossLogger(LogContext logContext, String name) {
        String loggerName = name == null || name.equals(LOG4J_ROOT_NAME) ? JBL_ROOT_NAME : name;
        return logContext.getLogger(loggerName);
    }

    public static LoggerRepository getLoggerRepository(LogContext logContext) {
        org.jboss.logmanager.Logger jbossRoot = JBossLogManagerFacade.getJBossLogger(logContext, JBL_ROOT_NAME);
        Object hierarchy = (Hierarchy)jbossRoot.getAttachment(HIERARCHY_KEY);
        if (hierarchy == null) {
            Object appearing;
            Object root = JBossLogManagerFacade.getLogger(jbossRoot);
            if (root == null && (appearing = (Logger)jbossRoot.attachIfAbsent(LOGGER_KEY, root = new RootLogger(JBossLevelMapping.getPriorityFor(jbossRoot.getLevel())))) != null) {
                root = appearing;
            }
            if ((appearing = (Hierarchy)jbossRoot.attachIfAbsent(HIERARCHY_KEY, hierarchy = new Hierarchy((Logger)root))) != null) {
                hierarchy = appearing;
            }
        }
        return hierarchy;
    }

    static Logger exists(String name) {
        org.jboss.logmanager.Logger logger = LogContext.getLogContext().getLoggerIfExists(name);
        return logger == null ? null : JBossLogManagerFacade.getLogger(logger);
    }

    static Logger getLogger(org.jboss.logmanager.Logger lmLogger) {
        return (Logger)lmLogger.getAttachment(LOGGER_KEY);
    }

    static Logger getOrCreateLogger(LoggerRepository repository, String name, LoggerFactory factory) {
        org.jboss.logmanager.Logger lmLogger = JBossLogManagerFacade.getJBossLogger(LogContext.getLogContext(), name);
        Logger logger = JBossLogManagerFacade.getLogger(lmLogger);
        if (logger == null) {
            logger = factory.makeNewLoggerInstance(name);
            Logger currentLogger = (Logger)lmLogger.attachIfAbsent(LOGGER_KEY, (Object)logger);
            if (currentLogger != null) {
                logger = currentLogger;
            }
            JBossLogManagerFacade.updateParents(repository, logger);
        }
        return logger;
    }

    static Collection<Logger> getLoggers() {
        LogContext logContext = LogContext.getLogContext();
        List<String> loggerNames = logContext.getLoggingMXBean().getLoggerNames();
        ArrayList<Logger> currentLoggers = new ArrayList<Logger>(loggerNames.size());
        for (String name : loggerNames) {
            Logger logger;
            org.jboss.logmanager.Logger lmLogger = logContext.getLoggerIfExists(name);
            if (lmLogger == null || (logger = JBossLogManagerFacade.getLogger(lmLogger)) == null) continue;
            currentLoggers.add(logger);
        }
        return currentLoggers;
    }

    private static void updateParents(LoggerRepository repository, Logger cat) {
        LogContext logContext = LogContext.getLogContext();
        String name = cat.getName();
        int length = name.length();
        boolean addRootAsParent = true;
        int i = name.lastIndexOf(46, length - 1);
        while (i >= 0) {
            org.jboss.logmanager.Logger lmLogger = logContext.getLoggerIfExists(name.substring(0, i));
            if (lmLogger != null) {
                cat.parent = JBossLogManagerFacade.getLogger(lmLogger);
                if (cat.parent != null) {
                    addRootAsParent = false;
                    break;
                }
            }
            i = name.lastIndexOf(46, i - 1);
        }
        if (addRootAsParent) {
            cat.parent = repository.getRootLogger();
        }
    }
}

