/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.SarLogger;
import org.jboss.as.service.SarMessages;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class CreateDestroyService
extends AbstractService {
    private final Method createMethod;
    private final Method destroyMethod;
    private final ServiceComponentInstantiator componentInstantiator;
    private ManagedReference managedReference;

    CreateDestroyService(Object mBeanInstance, Method createMethod, Method destroyMethod, ServiceComponentInstantiator componentInstantiator, ServiceName duServiceName, ClassLoader mbeanContextClassLoader) {
        super(mBeanInstance, duServiceName, mbeanContextClassLoader);
        this.createMethod = createMethod;
        this.destroyMethod = destroyMethod;
        this.componentInstantiator = componentInstantiator;
    }

    public void start(StartContext context) throws StartException {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Creating Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.createMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            throw SarMessages.MESSAGES.failedExecutingLegacyMethod(e, "create()");
        }
        if (this.componentInstantiator != null) {
            this.managedReference = this.componentInstantiator.initializeInstance(this.getValue());
        }
    }

    public void stop(StopContext context) {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Destroying Service: %s", context.getController().getName());
        }
        if (this.managedReference != null) {
            this.managedReference.release();
        }
        try {
            this.invokeLifecycleMethod(this.destroyMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod(e, "create()");
        }
    }
}

