/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.io.IOException;
import java.io.InputStream;
import org.hornetq.api.core.HornetQBuffer;

public class HornetQBufferInputStream
extends InputStream {
    private HornetQBuffer bb;

    public HornetQBufferInputStream(HornetQBuffer paramByteBuffer) {
        this.bb = paramByteBuffer;
    }

    @Override
    public int read() throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (this.remainingBytes() == 0) {
            return -1;
        }
        return this.bb.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] byteArray) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        return this.read(byteArray, 0, byteArray.length);
    }

    @Override
    public int read(byte[] byteArray, int off, int len) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (byteArray == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > byteArray.length || len < 0 || off + len > byteArray.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int size = Math.min(this.remainingBytes(), len);
        if (size == 0) {
            return -1;
        }
        this.bb.readBytes(byteArray, off, size);
        return size;
    }

    @Override
    public long skip(long len) throws IOException {
        if (this.bb == null) {
            throw new IOException("skip on a closed InputStream");
        }
        if (len <= 0L) {
            return 0L;
        }
        int size = Math.min(this.remainingBytes(), (int)len);
        this.bb.skipBytes(size);
        return size;
    }

    @Override
    public int available() throws IOException {
        if (this.bb == null) {
            throw new IOException("available on a closed InputStream");
        }
        return this.remainingBytes();
    }

    @Override
    public void close() throws IOException {
        this.bb = null;
    }

    @Override
    public synchronized void mark(int paramInt) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private int remainingBytes() {
        return this.bb.writerIndex() - this.bb.readerIndex();
    }
}

