/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class SeqnoList
implements Streamable,
Iterable<Long> {
    protected final List<Seqno> seqnos = new ArrayList<Seqno>();

    public SeqnoList() {
    }

    public SeqnoList(long seqno) {
        this.add(seqno);
    }

    public SeqnoList(long from, long to) {
        this.add(from, to);
    }

    public SeqnoList add(long seqno) {
        this.seqnos.add(new Seqno(seqno));
        return this;
    }

    public SeqnoList add(long ... seqnos) {
        if (seqnos != null) {
            for (long seqno : seqnos) {
                this.add(seqno);
            }
        }
        return this;
    }

    public SeqnoList add(long from, long to) {
        this.seqnos.add(new SeqnoRange(from, to));
        return this;
    }

    public void remove(long min_seqno) {
        Iterator<Seqno> it = this.seqnos.iterator();
        while (it.hasNext()) {
            Seqno tmp = it.next();
            if (tmp instanceof SeqnoRange) {
                SeqnoRange range = (SeqnoRange)tmp;
                if (range.to <= min_seqno) {
                    it.remove();
                    continue;
                }
                if (range.from > min_seqno) continue;
                range.from = min_seqno + 1L;
                continue;
            }
            if (tmp.from > min_seqno) continue;
            it.remove();
        }
    }

    public void removeHigherThan(long max_seqno) {
        Iterator<Seqno> it = this.seqnos.iterator();
        while (it.hasNext()) {
            Seqno tmp = it.next();
            if (tmp instanceof SeqnoRange) {
                SeqnoRange range = (SeqnoRange)tmp;
                if (range.from > max_seqno) {
                    it.remove();
                    continue;
                }
                if (range.to <= max_seqno) continue;
                range.to = max_seqno;
                continue;
            }
            if (tmp.from <= max_seqno) continue;
            it.remove();
        }
    }

    public long getLast() {
        int size = this.seqnos.size();
        if (size == 0) {
            return 0L;
        }
        Seqno seqno = this.seqnos.get(size - 1);
        return seqno instanceof SeqnoRange ? ((SeqnoRange)seqno).to : seqno.from;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeInt(this.seqnos.size());
        for (Seqno seqno : this.seqnos) {
            if (seqno instanceof SeqnoRange) {
                SeqnoRange range = (SeqnoRange)seqno;
                out.writeBoolean(true);
                Util.writeLongSequence(range.from, range.to, out);
                continue;
            }
            out.writeBoolean(false);
            Util.writeLong(seqno.from, out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            if (in.readBoolean()) {
                long[] tmp = Util.readLongSequence(in);
                this.seqnos.add(new SeqnoRange(tmp[0], tmp[1]));
                continue;
            }
            this.seqnos.add(new Seqno(Util.readLong(in)));
        }
    }

    public int serializedSize() {
        int retval = 4 + this.seqnos.size() * 1;
        for (Seqno seqno : this.seqnos) {
            if (seqno instanceof SeqnoRange) {
                SeqnoRange range = (SeqnoRange)seqno;
                retval += Util.size(range.from, range.to);
                continue;
            }
            retval += Util.size(seqno.from);
        }
        return retval;
    }

    public int size() {
        int retval = 0;
        for (Seqno seqno : this.seqnos) {
            if (seqno instanceof SeqnoRange) {
                SeqnoRange range = (SeqnoRange)seqno;
                retval = (int)((long)retval + (range.to - range.from + 1L));
                continue;
            }
            ++retval;
        }
        return retval;
    }

    public String toString() {
        return this.seqnos.toString();
    }

    @Override
    public Iterator<Long> iterator() {
        return new SeqnoListIterator();
    }

    protected class SeqnoListIterator
    implements Iterator<Long> {
        protected int index = 0;
        protected SeqnoRange range = null;
        protected long range_index = -1L;

        protected SeqnoListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.range != null && this.range_index < this.range.to || this.index < SeqnoList.this.seqnos.size();
        }

        @Override
        public Long next() {
            Seqno next;
            if (this.range != null) {
                if (this.range_index < this.range.to) {
                    return ++this.range_index;
                }
                this.range = null;
            }
            if (this.index >= SeqnoList.this.seqnos.size()) {
                throw new NoSuchElementException("index " + this.index + " is >= size " + SeqnoList.this.seqnos.size());
            }
            if ((next = SeqnoList.this.seqnos.get(this.index++)) instanceof SeqnoRange) {
                this.range = (SeqnoRange)next;
                this.range_index = this.range.from;
                return this.range_index;
            }
            return next.from;
        }

        @Override
        public void remove() {
        }
    }

    protected static class SeqnoRange
    extends Seqno {
        protected long to;

        public SeqnoRange(long from, long to) {
            super(from);
            this.to = to;
            if (to < from) {
                throw new IllegalArgumentException("to (" + to + ") needs to be >= from (" + from + ")");
            }
        }

        @Override
        public String toString() {
            return super.toString() + "-" + this.to;
        }
    }

    protected static class Seqno {
        protected long from;

        public Seqno(long num) {
            this.from = num;
        }

        public String toString() {
            return String.valueOf(this.from);
        }
    }
}

