/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.StandardRole;

public class SuperUserRoleMapper
implements RoleMapper {
    private final Set<String> SUPERUSER = Collections.singleton(StandardRole.SUPERUSER.toString());
    private final AuthorizerConfiguration authorizerConfiguration;

    public SuperUserRoleMapper(AuthorizerConfiguration configuration) {
        this.authorizerConfiguration = configuration;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetAttribute attribute) {
        return this.SUPERUSER;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetResource resource) {
        return this.SUPERUSER;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Set<String> operationHeaderRoles) {
        return this.SUPERUSER;
    }

    @Override
    public boolean canRunAs(Set<String> mappedRoles, String runAsRole) {
        if (runAsRole == null) {
            return false;
        }
        boolean hasRole = this.authorizerConfiguration.hasRole(runAsRole);
        boolean isSuperUser = mappedRoles.contains(StandardRole.SUPERUSER.toString());
        if (isSuperUser && !hasRole) {
            throw ControllerMessages.MESSAGES.unknownRole(runAsRole);
        }
        return hasRole && isSuperUser;
    }
}

