/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.impl.SingleSignOnManager;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManagerService;

class SingleSignOnAdd
extends AbstractAddStepHandler {
    SingleSignOnAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : SingleSignOnDefinition.ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress hostAddress = address.subAddress(0, address.size() - 1);
        PathAddress serverAddress = hostAddress.subAddress(0, hostAddress.size() - 1);
        ModelNode domainModelNode = SingleSignOnDefinition.DOMAIN.resolveModelAttribute(context, model);
        String domain = domainModelNode.isDefined() ? domainModelNode.asString() : null;
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.ssoServiceName(serverName, hostName);
        ServiceName virtualHostServiceName = UndertowService.virtualHostName(serverName, hostName);
        ServiceTarget target = context.getServiceTarget();
        ServiceName managerServiceName = serviceName.append(new String[]{"manager"});
        ServiceController factoryController = SingleSignOnManagerService.build(target, managerServiceName, virtualHostServiceName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(factoryController);
        }
        SingleSignOnService service = new SingleSignOnService(domain);
        ServiceController sc = target.addService(serviceName, (Service)service).addDependency(virtualHostServiceName, Host.class, service.getHost()).addDependency(managerServiceName, SingleSignOnManager.class, service.getSingleSignOnSessionManager()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }
}

