/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedJBossThreadPoolExecutorService;
import org.jboss.as.threads.ThreadsMessages;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EventListener;
import org.jboss.threads.JBossThreadPoolExecutor;

public class UnboundedQueueThreadPoolService
implements Service<ManagedJBossThreadPoolExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private ManagedJBossThreadPoolExecutorService executor;
    private int maxThreads;
    private TimeSpec keepAlive;

    public UnboundedQueueThreadPoolService(int maxThreads, TimeSpec keepAlive) {
        this.maxThreads = maxThreads;
        this.keepAlive = keepAlive;
    }

    public synchronized void start(StartContext context) throws StartException {
        TimeSpec keepAliveSpec = this.keepAlive;
        long keepAliveTime = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getUnit().toNanos(keepAliveSpec.getDuration());
        JBossThreadPoolExecutor jbossExecutor = new JBossThreadPoolExecutor(this.maxThreads, this.maxThreads, keepAliveTime, TimeUnit.NANOSECONDS, new LinkedBlockingQueue(), (ThreadFactory)this.threadFactoryValue.getValue());
        this.executor = new ManagedJBossThreadPoolExecutorService(jbossExecutor);
    }

    public synchronized void stop(StopContext context) {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        context.asynchronous();
        executor.internalShutdown();
        executor.addShutdownListener(new EventListener<StopContext>(){

            public void handleEvent(StopContext stopContext) {
                stopContext.complete();
            }
        }, context);
        this.executor = null;
    }

    public synchronized ManagedJBossThreadPoolExecutorService getValue() throws IllegalStateException {
        ManagedJBossThreadPoolExecutorService value = this.executor;
        if (value == null) {
            throw ThreadsMessages.MESSAGES.unboundedQueueThreadPoolExecutorUninitialized();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public synchronized void setMaxThreads(int maxThreads) {
        ManagedJBossThreadPoolExecutorService executor = this.executor;
        if (executor != null) {
            if (maxThreads < this.maxThreads) {
                executor.setCoreThreads(maxThreads);
                executor.setMaxThreads(maxThreads);
            } else {
                executor.setMaxThreads(maxThreads);
                executor.setCoreThreads(maxThreads);
            }
        }
        this.maxThreads = maxThreads;
    }

    public synchronized void setKeepAlive(TimeSpec keepAlive) {
        this.keepAlive = keepAlive;
        ManagedJBossThreadPoolExecutorService executor = this.executor;
        if (executor != null) {
            executor.setKeepAlive(keepAlive);
        }
    }

    public int getActiveCount() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getActiveCount();
    }

    public long getCompletedTaskCount() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getCompletedTaskCount();
    }

    public int getCurrentThreadCount() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getCurrentThreadCount();
    }

    public int getLargestPoolSize() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getLargestPoolSize();
    }

    public int getLargestThreadCount() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getLargestThreadCount();
    }

    public int getRejectedCount() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getRejectedCount();
    }

    public long getTaskCount() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getTaskCount();
    }

    public int getQueueSize() {
        ManagedJBossThreadPoolExecutorService executor = this.getValue();
        return executor.getQueueSize();
    }

    TimeUnit getKeepAliveUnit() {
        return this.keepAlive == null ? TimeSpec.DEFAULT_KEEPALIVE.getUnit() : this.keepAlive.getUnit();
    }
}

