/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.internal.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.internal.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.internal.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.internal.synchronization.work.DelWorkUnit;
import org.hibernate.envers.internal.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.internal.synchronization.work.ModWorkUnit;
import org.hibernate.envers.internal.synchronization.work.WorkUnitMergeVisitor;
import org.hibernate.envers.internal.tools.ArraysTools;
import org.hibernate.persister.entity.EntityPersister;

public class AddWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final Object[] state;
    private final Map<String, Object> data;

    public AddWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditConfiguration verCfg, Serializable id, EntityPersister entityPersister, Object[] state) {
        super(sessionImplementor, entityName, verCfg, id, RevisionType.ADD);
        this.data = new HashMap<String, Object>();
        this.state = state;
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().map(sessionImplementor, this.data, entityPersister.getPropertyNames(), state, null);
    }

    public AddWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditConfiguration verCfg, Serializable id, Map<String, Object> data) {
        super(sessionImplementor, entityName, verCfg, id, RevisionType.ADD);
        this.data = data;
        String[] propertyNames = sessionImplementor.getFactory().getEntityPersister(this.getEntityName()).getPropertyNames();
        this.state = ArraysTools.mapToArray(data, propertyNames);
    }

    @Override
    public boolean containsWork() {
        return true;
    }

    @Override
    public Map<String, Object> generateData(Object revisionData) {
        this.fillDataWithId(this.data, revisionData);
        return this.data;
    }

    public Object[] getState() {
        return this.state;
    }

    @Override
    public AuditWorkUnit merge(AddWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(ModWorkUnit second) {
        return new AddWorkUnit(this.sessionImplementor, this.entityName, this.verCfg, this.id, second.getData());
    }

    @Override
    public AuditWorkUnit merge(DelWorkUnit second) {
        return null;
    }

    @Override
    public AuditWorkUnit merge(CollectionChangeWorkUnit second) {
        second.mergeCollectionModifiedData(this.data);
        return this;
    }

    @Override
    public AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit second) {
        return FakeBidirectionalRelationWorkUnit.merge(second, this, second.getNestedWorkUnit());
    }

    @Override
    public AuditWorkUnit dispatch(WorkUnitMergeVisitor first) {
        return first.merge(this);
    }
}

