/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.util.Date;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ws.api.monitoring.Record;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.management.ManagedEndpointMBean;
import org.jboss.ws.common.monitoring.ManagedRecordProcessor;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;

public class ManagedEndpoint
implements ManagedEndpointMBean {
    private Endpoint endpoint;
    private MBeanServer mbeanServer;

    public ManagedEndpoint(Endpoint endpoint, MBeanServer mbeanServer) {
        this.endpoint = endpoint;
        this.mbeanServer = mbeanServer;
    }

    @Override
    public String getAddress() {
        return this.endpoint.getAddress();
    }

    @Override
    public long getAverageProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getAverageProcessingTime() : 0L;
    }

    @Override
    public long getFaultCount() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getFaultCount() : 0L;
    }

    @Override
    public long getMaxProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getMaxProcessingTime() : 0L;
    }

    @Override
    public long getMinProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getMinProcessingTime() : 0L;
    }

    @Override
    public long getRequestCount() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getRequestCount() : 0L;
    }

    @Override
    public long getResponseCount() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getResponseCount() : 0L;
    }

    @Override
    public Date getStartTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getStartTime() : null;
    }

    @Override
    public Date getStopTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getStopTime() : null;
    }

    @Override
    public long getTotalProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getTotalProcessingTime() : 0L;
    }

    @Override
    public void start() {
        this.endpoint.getLifecycleHandler().start(this.endpoint);
    }

    @Override
    public void stop() {
        this.endpoint.getLifecycleHandler().stop(this.endpoint);
    }

    @Override
    public void processRecord(Record record) {
        this.endpoint.processRecord(record);
    }

    @Override
    public void addRecordProcessor(RecordProcessor processor) {
        ObjectName on = ObjectNameFactory.create(this.endpoint.getName() + ",recordProcessor=" + processor.getName());
        this.getRecordProcessors().add(processor);
        try {
            this.mbeanServer.registerMBean(processor, on);
        }
        catch (JMException ex) {
            Loggers.MANAGEMENT_LOGGER.cannotRegisterProvidedProcessor(on, ex);
            try {
                this.mbeanServer.registerMBean(new ManagedRecordProcessor(processor), on);
            }
            catch (JMException innerEx) {
                Loggers.MANAGEMENT_LOGGER.cannotRegisterProcessorWithJmxServer(on, innerEx);
            }
        }
    }

    @Override
    public List<RecordProcessor> getRecordProcessors() {
        return this.endpoint.getRecordProcessors();
    }

    @Override
    public void setRecordProcessors(List<RecordProcessor> processors) {
        ObjectName on;
        for (RecordProcessor processor : this.endpoint.getRecordProcessors()) {
            on = ObjectNameFactory.create(this.endpoint.getName() + ",recordProcessor=" + processor.getName());
            try {
                this.mbeanServer.unregisterMBean(on);
            }
            catch (JMException ex) {
                Loggers.MANAGEMENT_LOGGER.cannotUnregisterProcessorWithJmxServer(on, ex);
            }
        }
        this.endpoint.setRecordProcessors(processors);
        for (RecordProcessor processor : processors) {
            on = ObjectNameFactory.create(this.endpoint.getName() + ",recordProcessor=" + processor.getName());
            try {
                this.mbeanServer.registerMBean(processor, on);
            }
            catch (JMException ex) {
                Loggers.MANAGEMENT_LOGGER.cannotRegisterProvidedProcessor(on, ex);
                try {
                    this.mbeanServer.registerMBean(new ManagedRecordProcessor(processor), on);
                }
                catch (JMException innerEx) {
                    Loggers.MANAGEMENT_LOGGER.cannotRegisterProcessorWithJmxServer(on, innerEx);
                }
            }
        }
    }
}

