/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.deployments.AbstractLoggingDeploymentProcessor;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LoggingConfigDeploymentProcessor
extends AbstractLoggingDeploymentProcessor
implements DeploymentUnitProcessor {
    @Deprecated
    public static final String PER_DEPLOYMENT_LOGGING = "org.jboss.as.logging.per-deployment";
    private static final String ENCODING = "utf-8";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String LOG4J_XML = "log4j.xml";
    private static final String JBOSS_LOG4J_XML = "jboss-log4j.xml";
    private static final String DEFAULT_PROPERTIES = "logging.properties";
    private static final String JBOSS_PROPERTIES = "jboss-logging.properties";
    private static final Object CONTEXT_LOCK = new Object();
    private final String attributeName;
    private final boolean process;

    public LoggingConfigDeploymentProcessor(WildFlyLogContextSelector logContextSelector, String attributeName, boolean process) {
        super(logContextSelector);
        this.attributeName = attributeName;
        this.process = process;
    }

    @Override
    protected void processDeployment(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, ResourceRoot root) throws DeploymentUnitProcessingException {
        block9: {
            boolean process = this.process;
            Properties systemProps = WildFlySecurityManager.getSystemPropertiesPrivileged();
            if (systemProps.containsKey(PER_DEPLOYMENT_LOGGING)) {
                LoggingLogger.ROOT_LOGGER.perDeploymentPropertyDeprecated(PER_DEPLOYMENT_LOGGING, this.attributeName);
                if (process) {
                    process = Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)PER_DEPLOYMENT_LOGGING, (String)Boolean.toString(true)));
                } else {
                    LoggingLogger.ROOT_LOGGER.perLoggingDeploymentIgnored(PER_DEPLOYMENT_LOGGING, this.attributeName, deploymentUnit.getName());
                }
            }
            if (!process) break block9;
            LoggingLogger.ROOT_LOGGER.trace("Scanning for logging configuration files.");
            List<DeploymentUnit> subDeployments = LoggingConfigDeploymentProcessor.getSubDeployments(deploymentUnit);
            VirtualFile configFile = this.findConfigFile(root);
            if (configFile != null) {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                LogContext logContext = LoggingConfigDeploymentProcessor.isLog4jConfiguration(configFile.getName()) ? LogContext.create((boolean)true) : LogContext.create();
                if (!this.configure(configFile, (ClassLoader)module.getClassLoader(), logContext)) {
                    return;
                }
                this.registerLogContext(deploymentUnit, module, logContext);
                for (DeploymentUnit subDeployment : subDeployments) {
                    Module subDeploymentModule;
                    if (subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
                        this.processDeployment(phaseContext, subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                    }
                    if (!subDeployment.hasAttachment(Attachments.MODULE) || LoggingConfigDeploymentProcessor.hasRegisteredLogContext(subDeployment) || (subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE)) == null) continue;
                    this.registerLogContext(subDeployment, subDeploymentModule, logContext);
                }
            } else {
                for (DeploymentUnit subDeployment : subDeployments) {
                    if (!subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) continue;
                    this.processDeployment(phaseContext, subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                }
            }
        }
    }

    private VirtualFile findConfigFile(ResourceRoot resourceRoot) throws DeploymentUnitProcessingException {
        VirtualFile root = resourceRoot.getRoot();
        VirtualFile file = root.getChild("META-INF");
        VirtualFile result = this.findConfigFile(file);
        if (result == null) {
            file = root.getChild("WEB-INF/classes");
            result = this.findConfigFile(file);
        }
        return result;
    }

    private VirtualFile findConfigFile(VirtualFile file) throws DeploymentUnitProcessingException {
        VirtualFile result = null;
        try {
            List configFiles = file.getChildren((VirtualFileFilter)ConfigFilter.INSTANCE);
            for (VirtualFile configFile : configFiles) {
                String fileName = configFile.getName();
                if (DEFAULT_PROPERTIES.equals(fileName) || JBOSS_PROPERTIES.equals(fileName)) {
                    if (result != null) {
                        LoggingLogger.ROOT_LOGGER.debugf("The previously found configuration file '%s' is being ignored in favour of '%s'", result, configFile);
                    }
                    return configFile;
                }
                if (!LOG4J_PROPERTIES.equals(fileName) && !LOG4J_XML.equals(fileName) && !JBOSS_LOG4J_XML.equals(fileName)) continue;
                result = configFile;
            }
        }
        catch (IOException e) {
            throw LoggingMessages.MESSAGES.errorProcessingLoggingConfiguration(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configure(VirtualFile configFile, ClassLoader classLoader, LogContext logContext) throws DeploymentUnitProcessingException {
        InputStream configStream;
        boolean result;
        block12: {
            result = false;
            configStream = null;
            try {
                LoggingLogger.ROOT_LOGGER.debugf("Found logging configuration file: %s", configFile);
                String fileName = configFile.getName();
                configStream = configFile.openStream();
                if (LoggingConfigDeploymentProcessor.isLog4jConfiguration(fileName)) {
                    ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                    LogContext old = this.logContextSelector.getAndSet(CONTEXT_LOCK, logContext);
                    try {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)classLoader);
                        if (LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName)) {
                            new DOMConfigurator().doConfigure(configStream, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext));
                        } else {
                            Properties properties = new Properties();
                            properties.load(new InputStreamReader(configStream, ENCODING));
                            new org.apache.log4j.PropertyConfigurator().doConfigure(properties, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext));
                        }
                    }
                    finally {
                        this.logContextSelector.getAndSet(CONTEXT_LOCK, old);
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                    }
                    result = true;
                    break block12;
                }
                Properties properties = new Properties();
                properties.load(new InputStreamReader(configStream, ENCODING));
                if (LoggingConfigDeploymentProcessor.isJulConfiguration(properties)) {
                    LoggingLogger.ROOT_LOGGER.julConfigurationFileFound(configFile.getName());
                    break block12;
                }
                PropertyConfigurator propertyConfigurator = new PropertyConfigurator(logContext);
                propertyConfigurator.configure(properties);
                result = true;
            }
            catch (Exception e) {
                try {
                    throw LoggingMessages.MESSAGES.failedToConfigureLogging(e, configFile.getName());
                }
                catch (Throwable throwable) {
                    LoggingConfigDeploymentProcessor.safeClose(configStream);
                    throw throwable;
                }
            }
        }
        LoggingConfigDeploymentProcessor.safeClose(configStream);
        return result;
    }

    private static boolean isLog4jConfiguration(String fileName) {
        return LOG4J_PROPERTIES.equals(fileName) || LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName);
    }

    private static boolean isJulConfiguration(Properties properties) {
        String prop;
        if (properties.containsKey(".level")) {
            return true;
        }
        if (properties.containsKey("handlers") && (prop = properties.getProperty("handlers", "")) != null && !prop.trim().isEmpty()) {
            String[] handlers;
            for (String handler : handlers = prop.split("\\s*,\\s*")) {
                String key = String.format("handler.%s", handler);
                if (properties.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ConfigFilter
    implements VirtualFileFilter {
        static final ConfigFilter INSTANCE = new ConfigFilter();
        private final Set<String> configFiles = new HashSet<String>(Arrays.asList("log4j.properties", "log4j.xml", "jboss-log4j.xml", "jboss-logging.properties", "logging.properties"));

        private ConfigFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return this.configFiles.contains(file.getName());
        }
    }
}

