/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;

class CharacterReader {
    static final char EOF = '\uffff';
    private final String input;
    private final int length;
    private int pos = 0;
    private int mark = 0;

    CharacterReader(String input) {
        Validate.notNull(input);
        this.input = input = input.replaceAll("\r\n?", "\n");
        this.length = input.length();
    }

    int pos() {
        return this.pos;
    }

    boolean isEmpty() {
        return this.pos >= this.length;
    }

    char current() {
        return this.isEmpty() ? (char)'\uffff' : this.input.charAt(this.pos);
    }

    char consume() {
        char val = this.isEmpty() ? (char)'\uffff' : (char)this.input.charAt(this.pos);
        ++this.pos;
        return val;
    }

    void unconsume() {
        --this.pos;
    }

    void advance() {
        ++this.pos;
    }

    void mark() {
        this.mark = this.pos;
    }

    void rewindToMark() {
        this.pos = this.mark;
    }

    String consumeAsString() {
        return this.input.substring(this.pos, this.pos++);
    }

    String consumeTo(char c) {
        int offset = this.input.indexOf(c, this.pos);
        if (offset != -1) {
            String consumed = this.input.substring(this.pos, offset);
            this.pos += consumed.length();
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq) {
        int offset = this.input.indexOf(seq, this.pos);
        if (offset != -1) {
            String consumed = this.input.substring(this.pos, offset);
            this.pos += consumed.length();
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeToAny(char ... seq) {
        int start = this.pos;
        block0: while (!this.isEmpty()) {
            char c = this.input.charAt(this.pos);
            for (char seek : seq) {
                if (seek == c) break block0;
            }
            ++this.pos;
        }
        return this.pos > start ? this.input.substring(start, this.pos) : "";
    }

    String consumeToEnd() {
        String data = this.input.substring(this.pos, this.input.length());
        this.pos = this.input.length();
        return data;
    }

    String consumeLetterSequence() {
        char c;
        int start = this.pos;
        while (!this.isEmpty() && ((c = this.input.charAt(this.pos)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            ++this.pos;
        }
        return this.input.substring(start, this.pos);
    }

    String consumeHexSequence() {
        char c;
        int start = this.pos;
        while (!this.isEmpty() && ((c = this.input.charAt(this.pos)) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.pos;
        }
        return this.input.substring(start, this.pos);
    }

    String consumeDigitSequence() {
        char c;
        int start = this.pos;
        while (!this.isEmpty() && (c = this.input.charAt(this.pos)) >= '0' && c <= '9') {
            ++this.pos;
        }
        return this.input.substring(start, this.pos);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.input.charAt(this.pos) == c;
    }

    boolean matches(String seq) {
        return this.input.startsWith(seq, this.pos);
    }

    boolean matchesIgnoreCase(String seq) {
        return this.input.regionMatches(true, this.pos, seq, 0, seq.length());
    }

    boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input.charAt(this.pos);
        for (char seek : seq) {
            if (seek != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input.charAt(this.pos);
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input.charAt(this.pos);
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String seq) {
        if (this.matches(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq) {
        String loScan = seq.toLowerCase();
        String hiScan = seq.toUpperCase();
        return this.input.indexOf(loScan, this.pos) > -1 || this.input.indexOf(hiScan, this.pos) > -1;
    }

    public String toString() {
        return this.input.substring(this.pos);
    }
}

