/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.java;

import java.io.File;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.RequirementMatcherFactory;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ToolchainFactory.class, hint="jdk")
public class DefaultJavaToolchainFactory
implements ToolchainFactory {
    @Requirement
    private Logger logger;

    @Override
    public ToolchainPrivate createToolchain(ToolchainModel model) throws MisconfiguredToolchainException {
        Xpp3Dom[] provides;
        if (model == null) {
            return null;
        }
        DefaultJavaToolChain jtc = new DefaultJavaToolChain(model, this.logger);
        Xpp3Dom dom = (Xpp3Dom)model.getConfiguration();
        Xpp3Dom javahome = dom.getChild("jdkHome");
        if (javahome == null) {
            throw new MisconfiguredToolchainException("Java toolchain without the jdkHome configuration element.");
        }
        File normal = new File(FileUtils.normalize((String)javahome.getValue()));
        if (!normal.exists()) {
            throw new MisconfiguredToolchainException("Non-existing JDK home configuration at " + normal.getAbsolutePath());
        }
        jtc.setJavaHome(FileUtils.normalize((String)javahome.getValue()));
        dom = (Xpp3Dom)model.getProvides();
        for (Xpp3Dom provide : provides = dom.getChildren()) {
            String key = provide.getName();
            String value = provide.getValue();
            if (value == null) {
                throw new MisconfiguredToolchainException("Provides token '" + key + "' doesn't have any value configured.");
            }
            if ("version".equals(key)) {
                jtc.addProvideToken(key, RequirementMatcherFactory.createVersionMatcher(value));
                continue;
            }
            jtc.addProvideToken(key, RequirementMatcherFactory.createExactMatcher(value));
        }
        return jtc;
    }

    @Override
    public ToolchainPrivate createDefaultToolchain() {
        return null;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

