/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.clustering.jgroups;

import java.net.URL;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.Messages;

/**
 * JGroupsMessages
 *
 * logging id range: 10270 - 10279, 10390 - 10399
 *
 * @author <a href="mailto:jperkins@redhat.com">James R. Perkins</a>
 */
@MessageBundle(projectCode = "JBAS")
public interface JGroupsMessages {
    /**
     * The messages.
     */
    JGroupsMessages MESSAGES = Messages.getBundle(JGroupsMessages.class);

    /**
     * A message indicating a file could not be parsed.
     *
     * @param url the path to the file.
     *
     * @return the message.
     */
    @Message(id = 10270, value = "Failed to parse %s")
    String parserFailure(URL url);

    /**
     * A message indicating a resource could not be located.
     *
     * @param resource the resource that could not be located.
     *
     * @return the message.
     */
    @Message(id = 10271, value = "Failed to locate %s")
    String notFound(String resource);

    @Message(id = 10272, value = "A node named %s already exists in this cluster. Perhaps there is already a server running on this host? If so, restart this server with a unique node name, via -Djboss.node.name=<node-name>")
    IllegalStateException duplicateNodeName(String name);

    @Message(id = 10273, value = "Transport for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.")
    OperationFailedException transportNotDefined(String stackName);

    @Message(id = 10274, value = "Protocol list for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.")
    OperationFailedException protocolListNotDefined(String stackName);

    @Message(id = 10275, value = "Protocol with relative path %s is already defined.")
    OperationFailedException protocolAlreadyDefined(String relativePath);

    @Message(id = 10276, value = "Protocol with relative path %s is not defined.")
    OperationFailedException protocolNotDefined(String relativePath);

    @Message(id = 10277, value = "Property %s for protocol with relative path %s is not defined.")
    OperationFailedException propertyNotDefined(String propertyName, String protocolRelativePath);

    @Message(id = 10278, value = "Unknown metric %s")
    String unknownMetric(String metricName);

    @Message(id = 10279, value = "Unable to load protocol class %s")
    OperationFailedException unableToLoadProtocolClass(String protocolName);

    @Message(id = 10390, value = "Privileged access exception on attribute %s")
    String privilegedAccessExceptionForAttribute(String attrName);

    @Message(id = 10391, value = "Instantiation exception on converter for attribute %s")
    String instantiationExceptionOnConverterForAttribute(String attrName);

    @Message(id = 10392, value = "Protocol %s not found in current stack")
    String protocolNotFoundInStack(String protocolName);

    @Message(id = 10393, value = "Unable to load protocol class %s")
    String unableToLoadProtocol(String protocolName);
}
