/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.naming.jndi;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.jboss.as.jacorb.JacORBMessages;

public final class UrlUtil {
    private UrlUtil() {
    }

    public static String decode(String s) throws MalformedURLException {
        try {
            return UrlUtil.decode(s, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw JacORBMessages.MESSAGES.unavailableISOLatin1Decoder();
        }
    }

    public static String decode(String s, String enc) throws MalformedURLException, UnsupportedEncodingException {
        int length = s.length();
        byte[] bytes = new byte[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) == '%') {
                ++i;
                try {
                    bytes[j++] = (byte)Integer.parseInt(s.substring(i, i + 2), 16);
                }
                catch (Exception e) {
                    throw JacORBMessages.MESSAGES.invalidURIEncoding(s);
                }
                ++i;
                continue;
            }
            bytes[j++] = (byte)s.charAt(i);
        }
        return new String(bytes, 0, j, enc);
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(enc);
        int count = bytes.length;
        String allowed = "=,+;.'-@&/$_()!~*:";
        char[] buf = new char[3 * count];
        int j = 0;
        for (int i = 0; i < count; ++i) {
            if (bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 65 && bytes[i] <= 90 || bytes[i] >= 48 && bytes[i] <= 57 || "=,+;.'-@&/$_()!~*:".indexOf(bytes[i]) >= 0) {
                buf[j++] = (char)bytes[i];
                continue;
            }
            buf[j++] = 37;
            buf[j++] = Character.forDigit(0xF & bytes[i] >>> 4, 16);
            buf[j++] = Character.forDigit(0xF & bytes[i], 16);
        }
        return new String(buf, 0, j);
    }
}

