/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.sql.Date;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.Audited;
import org.hibernate.envers.DefaultRevisionEntity;
import org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity;
import org.hibernate.envers.ModifiedEntityNames;
import org.hibernate.envers.RevisionEntity;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.RevisionInfoConfigurationResult;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.enhanced.SequenceIdRevisionEntity;
import org.hibernate.envers.enhanced.SequenceIdTrackingModifiedEntitiesRevisionEntity;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.revisioninfo.DefaultRevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.DefaultTrackingModifiedEntitiesRevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.tools.MutableBoolean;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class RevisionInfoConfiguration {
    private String revisionInfoEntityName;
    private PropertyData revisionInfoIdData;
    private PropertyData revisionInfoTimestampData;
    private PropertyData modifiedEntityNamesData;
    private Type revisionInfoTimestampType;
    private GlobalConfiguration globalCfg;
    private String revisionPropType;
    private String revisionPropSqlType;

    public RevisionInfoConfiguration(GlobalConfiguration globalCfg) {
        this.globalCfg = globalCfg;
        this.revisionInfoEntityName = globalCfg.isUseRevisionEntityWithNativeId() ? "org.hibernate.envers.DefaultRevisionEntity" : "org.hibernate.envers.enhanced.SequenceIdRevisionEntity";
        this.revisionInfoIdData = new PropertyData("id", "id", "field", null);
        this.revisionInfoTimestampData = new PropertyData("timestamp", "timestamp", "field", null);
        this.modifiedEntityNamesData = new PropertyData("modifiedEntityNames", "modifiedEntityNames", "field", null);
        this.revisionInfoTimestampType = new LongType();
        this.revisionPropType = "integer";
    }

    private Document generateDefaultRevisionInfoXmlMapping() {
        Document document = XMLHelper.getDocumentFactory().createDocument();
        Element classMapping = MetadataTools.createEntity(document, new AuditTableData(null, null, this.globalCfg.getDefaultSchemaName(), this.globalCfg.getDefaultCatalogName()), null, null);
        classMapping.addAttribute("name", this.revisionInfoEntityName);
        classMapping.addAttribute("table", "REVINFO");
        Element idProperty = MetadataTools.addNativelyGeneratedId(classMapping, this.revisionInfoIdData.getName(), this.revisionPropType, this.globalCfg.isUseRevisionEntityWithNativeId());
        MetadataTools.addColumn(idProperty, "REV", null, null, null, null, null, null, false);
        Element timestampProperty = MetadataTools.addProperty(classMapping, this.revisionInfoTimestampData.getName(), this.revisionInfoTimestampType.getName(), true, false);
        MetadataTools.addColumn(timestampProperty, "REVTSTMP", null, null, null, null, null, null, false);
        if (this.globalCfg.isTrackEntitiesChangedInRevision()) {
            this.generateEntityNamesTrackingTableMapping(classMapping, "modifiedEntityNames", this.globalCfg.getDefaultSchemaName(), this.globalCfg.getDefaultCatalogName(), "REVCHANGES", "REV", "ENTITYNAME", "string");
        }
        return document;
    }

    private void generateEntityNamesTrackingTableMapping(Element classMapping, String propertyName, String joinTableSchema, String joinTableCatalog, String joinTableName, String joinTablePrimaryKeyColumnName, String joinTableValueColumnName, String joinTableValueColumnType) {
        Element set = classMapping.addElement("set");
        set.addAttribute("name", propertyName);
        set.addAttribute("table", joinTableName);
        set.addAttribute("schema", joinTableSchema);
        set.addAttribute("catalog", joinTableCatalog);
        set.addAttribute("cascade", "persist, delete");
        set.addAttribute("fetch", "join");
        set.addAttribute("lazy", "false");
        Element key = set.addElement("key");
        key.addAttribute("column", joinTablePrimaryKeyColumnName);
        Element element = set.addElement("element");
        element.addAttribute("type", joinTableValueColumnType);
        Element column = element.addElement("column");
        column.addAttribute("name", joinTableValueColumnName);
    }

    private Element generateRevisionInfoRelationMapping() {
        Document document = XMLHelper.getDocumentFactory().createDocument();
        Element revRelMapping = document.addElement("key-many-to-one");
        revRelMapping.addAttribute("type", this.revisionPropType);
        revRelMapping.addAttribute("class", this.revisionInfoEntityName);
        if (this.revisionPropSqlType != null) {
            MetadataTools.addColumn(revRelMapping, "*", null, null, null, this.revisionPropSqlType, null, null, false);
        }
        return revRelMapping;
    }

    private void searchForRevisionInfoCfgInProperties(XClass clazz, ReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound, MutableBoolean modifiedEntityNamesFound, String accessType) {
        for (XProperty property : clazz.getDeclaredProperties(accessType)) {
            RevisionNumber revisionNumber = (RevisionNumber)property.getAnnotation(RevisionNumber.class);
            RevisionTimestamp revisionTimestamp = (RevisionTimestamp)property.getAnnotation(RevisionTimestamp.class);
            ModifiedEntityNames modifiedEntityNames = (ModifiedEntityNames)property.getAnnotation(ModifiedEntityNames.class);
            if (revisionNumber != null) {
                if (revisionNumberFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionNumber!");
                }
                XClass revisionNumberClass = property.getType();
                if (reflectionManager.equals(revisionNumberClass, Integer.class) || reflectionManager.equals(revisionNumberClass, Integer.TYPE)) {
                    this.revisionInfoIdData = new PropertyData(property.getName(), property.getName(), accessType, null);
                    revisionNumberFound.set();
                } else if (reflectionManager.equals(revisionNumberClass, Long.class) || reflectionManager.equals(revisionNumberClass, Long.TYPE)) {
                    this.revisionInfoIdData = new PropertyData(property.getName(), property.getName(), accessType, null);
                    revisionNumberFound.set();
                    this.revisionPropType = "long";
                } else {
                    throw new MappingException("The field annotated with @RevisionNumber must be of type int, Integer, long or Long");
                }
                Column revisionPropColumn = (Column)property.getAnnotation(Column.class);
                if (revisionPropColumn != null) {
                    this.revisionPropSqlType = revisionPropColumn.columnDefinition();
                }
            }
            if (revisionTimestamp != null) {
                if (revisionTimestampFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionTimestamp!");
                }
                XClass revisionTimestampClass = property.getType();
                if (reflectionManager.equals(revisionTimestampClass, Long.class) || reflectionManager.equals(revisionTimestampClass, Long.TYPE) || reflectionManager.equals(revisionTimestampClass, java.util.Date.class) || reflectionManager.equals(revisionTimestampClass, Date.class)) {
                    this.revisionInfoTimestampData = new PropertyData(property.getName(), property.getName(), accessType, null);
                    revisionTimestampFound.set();
                } else {
                    throw new MappingException("The field annotated with @RevisionTimestamp must be of type long, Long, java.util.Date or java.sql.Date");
                }
            }
            if (modifiedEntityNames == null) continue;
            if (modifiedEntityNamesFound.isSet()) {
                throw new MappingException("Only one property may be annotated with @ModifiedEntityNames!");
            }
            XClass modifiedEntityNamesClass = property.getType();
            if (reflectionManager.equals(modifiedEntityNamesClass, Set.class) && reflectionManager.equals(property.getElementClass(), String.class)) {
                this.modifiedEntityNamesData = new PropertyData(property.getName(), property.getName(), accessType, null);
                modifiedEntityNamesFound.set();
                continue;
            }
            throw new MappingException("The field annotated with @ModifiedEntityNames must be of Set<String> type.");
        }
    }

    private void searchForRevisionInfoCfg(XClass clazz, ReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound, MutableBoolean modifiedEntityNamesFound) {
        XClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.searchForRevisionInfoCfg(superclazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound);
        }
        this.searchForRevisionInfoCfgInProperties(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound, "field");
        this.searchForRevisionInfoCfgInProperties(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound, "property");
    }

    public RevisionInfoConfigurationResult configure(Configuration cfg, ReflectionManager reflectionManager) {
        boolean revisionEntityFound = false;
        DefaultRevisionInfoGenerator revisionInfoGenerator = null;
        Class revisionInfoClass = null;
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            XClass clazz;
            PersistentClass pc = (PersistentClass)classes.next();
            try {
                clazz = reflectionManager.classForName(pc.getClassName(), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException((Throwable)e);
            }
            RevisionEntity revisionEntity = (RevisionEntity)clazz.getAnnotation(RevisionEntity.class);
            if (revisionEntity == null) continue;
            if (revisionEntityFound) {
                throw new MappingException("Only one entity may be annotated with @RevisionEntity!");
            }
            if (clazz.getAnnotation(Audited.class) != null) {
                throw new MappingException("An entity annotated with @RevisionEntity cannot be audited!");
            }
            revisionEntityFound = true;
            MutableBoolean revisionNumberFound = new MutableBoolean();
            MutableBoolean revisionTimestampFound = new MutableBoolean();
            MutableBoolean modifiedEntityNamesFound = new MutableBoolean();
            this.searchForRevisionInfoCfg(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound);
            if (!revisionNumberFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionNumber!");
            }
            if (!revisionTimestampFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionTimestamp!");
            }
            this.revisionInfoEntityName = pc.getEntityName();
            revisionInfoClass = pc.getMappedClass();
            Class<? extends RevisionListener> revisionListenerClass = this.getRevisionListenerClass(revisionEntity.value());
            this.revisionInfoTimestampType = pc.getProperty(this.revisionInfoTimestampData.getName()).getType();
            if (this.globalCfg.isTrackEntitiesChangedInRevision() || this.globalCfg.isUseRevisionEntityWithNativeId() && DefaultTrackingModifiedEntitiesRevisionEntity.class.isAssignableFrom(revisionInfoClass) || !this.globalCfg.isUseRevisionEntityWithNativeId() && SequenceIdTrackingModifiedEntitiesRevisionEntity.class.isAssignableFrom(revisionInfoClass) || modifiedEntityNamesFound.isSet()) {
                revisionInfoGenerator = new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate(), this.modifiedEntityNamesData);
                this.globalCfg.setTrackEntitiesChangedInRevision(true);
                continue;
            }
            revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate());
        }
        Document revisionInfoXmlMapping = null;
        Class<? extends RevisionListener> revisionListenerClass = this.getRevisionListenerClass(RevisionListener.class);
        if (revisionInfoGenerator == null) {
            if (this.globalCfg.isTrackEntitiesChangedInRevision()) {
                revisionInfoClass = this.globalCfg.isUseRevisionEntityWithNativeId() ? DefaultTrackingModifiedEntitiesRevisionEntity.class : SequenceIdTrackingModifiedEntitiesRevisionEntity.class;
                this.revisionInfoEntityName = revisionInfoClass.getName();
                revisionInfoGenerator = new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate(), this.modifiedEntityNamesData);
            } else {
                revisionInfoClass = this.globalCfg.isUseRevisionEntityWithNativeId() ? DefaultRevisionEntity.class : SequenceIdRevisionEntity.class;
                revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate());
            }
            revisionInfoXmlMapping = this.generateDefaultRevisionInfoXmlMapping();
        }
        return new RevisionInfoConfigurationResult(revisionInfoGenerator, revisionInfoXmlMapping, new RevisionInfoQueryCreator(this.revisionInfoEntityName, this.revisionInfoIdData.getName(), this.revisionInfoTimestampData.getName(), this.isTimestampAsDate()), this.generateRevisionInfoRelationMapping(), new RevisionInfoNumberReader(revisionInfoClass, this.revisionInfoIdData), this.globalCfg.isTrackEntitiesChangedInRevision() ? new ModifiedEntityNamesReader(revisionInfoClass, this.modifiedEntityNamesData) : null, this.revisionInfoEntityName, revisionInfoClass, this.revisionInfoTimestampData);
    }

    private boolean isTimestampAsDate() {
        String typename = this.revisionInfoTimestampType.getName();
        return "date".equals(typename) || "time".equals(typename) || "timestamp".equals(typename);
    }

    private Class<? extends RevisionListener> getRevisionListenerClass(Class<? extends RevisionListener> defaultListener) {
        if (this.globalCfg.getRevisionListenerClass() != null) {
            return this.globalCfg.getRevisionListenerClass();
        }
        return defaultListener;
    }
}

