/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.entity.EntityBeanAllowedMethodsInformation;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentCreateService;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;
import org.jboss.as.ejb3.component.entity.entitycache.ReferenceCountingEntityCache;
import org.jboss.as.ejb3.component.entity.entitycache.TransactionLocalEntityCache;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EntityBeanComponent
extends EJBComponent
implements PooledComponent<EntityBeanComponentInstance> {
    public static final Object PRIMARY_KEY_CONTEXT_KEY = new Object();
    private final StatelessObjectFactory<EntityBeanComponentInstance> factory = new StatelessObjectFactory<EntityBeanComponentInstance>(){

        @Override
        public EntityBeanComponentInstance create() {
            return (EntityBeanComponentInstance)EntityBeanComponent.this.createInstance();
        }

        @Override
        public void destroy(EntityBeanComponentInstance obj) {
            obj.destroy();
        }
    };
    private final Pool<EntityBeanComponentInstance> pool;
    private final String poolName;
    private final ReadyEntityCache cache;
    private final Class<EJBHome> homeClass;
    private final Class<EJBLocalHome> localHomeClass;
    private final Class<EJBLocalObject> localClass;
    private final Class<EJBObject> remoteClass;
    private final Class<Object> primaryKeyClass;
    private final Boolean optimisticLocking;
    private final Method ejbStoreMethod;
    private final Method ejbLoadMethod;
    private final Method ejbActivateMethod;
    private final Method ejbPassivateMethod;
    private final Method unsetEntityContextMethod;
    private final InterceptorFactory ejbStore;
    private final InterceptorFactory ejbLoad;
    private final InterceptorFactory ejbActivate;
    private final InterceptorFactory ejbPassivate;
    private final InterceptorFactory unsetEntityContext;
    private Interceptor ejbStoreInterceptor;
    private Interceptor ejbLoadInterceptor;
    private Interceptor ejbActivateInterceptor;
    private Interceptor ejbPassivateInterceptor;
    private Interceptor unsetEntityContextInterceptor;

    protected EntityBeanComponent(EntityBeanComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.optimisticLocking = ejbComponentCreateService.getOptimisticLocking();
        PoolConfig poolConfig = ejbComponentCreateService.getPoolConfig();
        if (poolConfig == null) {
            EjbLogger.ROOT_LOGGER.debug("Pooling is disabled for entity bean " + ejbComponentCreateService.getComponentName());
            this.pool = null;
            this.poolName = null;
        } else {
            EjbLogger.ROOT_LOGGER.debug("Using pool config " + poolConfig + " to create pool for entity bean " + ejbComponentCreateService.getComponentName());
            this.pool = poolConfig.createPool(this.factory);
            this.poolName = poolConfig.getPoolName();
        }
        this.cache = this.createEntityCache(ejbComponentCreateService);
        this.homeClass = ejbComponentCreateService.getHomeClass();
        this.localHomeClass = ejbComponentCreateService.getLocalHomeClass();
        this.localClass = ejbComponentCreateService.getLocalClass();
        this.remoteClass = ejbComponentCreateService.getRemoteClass();
        this.primaryKeyClass = ejbComponentCreateService.getPrimaryKeyClass();
        this.ejbActivate = ejbComponentCreateService.getEjbActivate();
        this.ejbActivateMethod = ejbComponentCreateService.getEjbActivateMethod();
        this.ejbLoad = ejbComponentCreateService.getEjbLoad();
        this.ejbLoadMethod = ejbComponentCreateService.getEjbLoadMethod();
        this.ejbStore = ejbComponentCreateService.getEjbStore();
        this.ejbStoreMethod = ejbComponentCreateService.getEjbStoreMethod();
        this.ejbPassivate = ejbComponentCreateService.getEjbPassivate();
        this.ejbPassivateMethod = ejbComponentCreateService.getEjbPassivateMethod();
        this.unsetEntityContext = ejbComponentCreateService.getUnsetEntityContext();
        this.unsetEntityContextMethod = ejbComponentCreateService.getUnsetEntityContextMethod();
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        return new EntityBeanComponentInstance(this, preDestroyInterceptor, methodInterceptors);
    }

    public EntityBeanComponentInstance acquireUnAssociatedInstance() {
        if (this.pool != null) {
            return this.pool.get();
        }
        return this.factory.create();
    }

    protected void createInterceptors(InterceptorFactoryContext context) {
        super.createInterceptors(context);
        this.ejbStoreInterceptor = this.ejbStore.create(context);
        this.ejbLoadInterceptor = this.ejbLoad.create(context);
        this.ejbActivateInterceptor = this.ejbActivate.create(context);
        this.ejbPassivateInterceptor = this.ejbPassivate.create(context);
        this.unsetEntityContextInterceptor = this.unsetEntityContext.create(context);
    }

    public void releaseEntityBeanInstance(EntityBeanComponentInstance instance) {
        if (this.pool != null) {
            this.pool.release(instance);
        } else {
            this.factory.destroy(instance);
        }
    }

    public ReadyEntityCache getCache() {
        return this.cache;
    }

    protected ReadyEntityCache createEntityCache(EntityBeanComponentCreateService ejbComponentCreateService) {
        if (this.optimisticLocking == null || !this.optimisticLocking.booleanValue()) {
            return new ReferenceCountingEntityCache(this);
        }
        return new TransactionLocalEntityCache(this);
    }

    public EJBLocalObject getEJBLocalObject(Object pk) throws IllegalStateException {
        if (this.getEjbLocalObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.beanComponentMissingEjbObject(this.getComponentName(), "EJBLocalObject");
        }
        return this.createViewInstanceProxy(EJBLocalObject.class, Collections.singletonMap(PRIMARY_KEY_CONTEXT_KEY, pk), this.getEjbLocalObjectViewServiceName());
    }

    public EJBObject getEJBObject(Object pk) throws IllegalStateException {
        if (this.getEjbObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.beanComponentMissingEjbObject(this.getComponentName(), "EJBObject");
        }
        return this.createViewInstanceProxy(EJBObject.class, Collections.singletonMap(PRIMARY_KEY_CONTEXT_KEY, pk), this.getEjbObjectViewServiceName());
    }

    public Class<EJBHome> getHomeClass() {
        return this.homeClass;
    }

    public Class<EJBLocalHome> getLocalHomeClass() {
        return this.localHomeClass;
    }

    public Class<EJBLocalObject> getLocalClass() {
        return this.localClass;
    }

    public Class<EJBObject> getRemoteClass() {
        return this.remoteClass;
    }

    public Class<Object> getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public Method getEjbStoreMethod() {
        return this.ejbStoreMethod;
    }

    public Method getEjbLoadMethod() {
        return this.ejbLoadMethod;
    }

    public Method getEjbActivateMethod() {
        return this.ejbActivateMethod;
    }

    public Interceptor getEjbStore() {
        return this.ejbStoreInterceptor;
    }

    public Interceptor getEjbLoad() {
        return this.ejbLoadInterceptor;
    }

    public Interceptor getEjbActivate() {
        return this.ejbActivateInterceptor;
    }

    public Method getEjbPassivateMethod() {
        return this.ejbPassivateMethod;
    }

    public Interceptor getEjbPassivate() {
        return this.ejbPassivateInterceptor;
    }

    public Method getUnsetEntityContextMethod() {
        return this.unsetEntityContextMethod;
    }

    public Interceptor getUnsetEntityContext() {
        return this.unsetEntityContextInterceptor;
    }

    @Override
    public Pool<EntityBeanComponentInstance> getPool() {
        return this.pool;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return EntityBeanAllowedMethodsInformation.INSTANCE;
    }
}

